-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxilliary"
M.relevantDevice = nil 
M.clutchRatio = 0


local fl = 0
local abr = 0
local throttle = 0
local trim = 0
local trim_r = 0
local pitch = 0
local brakes = 0

local rbl1 = 0
local rbl2 = 0
local rbl3 = 0
local rbl4 = 0
local rollz = 0


local min = math.min
local max = math.max


local time = 0
local frequency = 0.5  -- Oscillations per second
local amplitude = 0.3  -- Peak value of the oscillation
local offset = 0     -- Value around which the oscillation occurs

local function onReset()
    fl = 0
    abr = 0
    electrics.values.flaps = fl

    rbl1 = 0
    rbl2 = 0
    electrics.values.rumble1 = rbl1
    electrics.values.rumble2 = rbl2
    rbl3 = 0
    rbl4 = 0
    electrics.values.rumble3 = rbl3
    electrics.values.rumble4 = rbl4

    electrics.values.airbrake = abr


    electrics.values.throttleup = 0
    electrics.values.throttledown = 0
    electrics.values.throttleaxis = 0
    electrics.values.throttlemtngoat = 0

    electrics.values.trimup = 0
    electrics.values.trimdown = 0
    electrics.values.trimmtngoat = 0

    electrics.values.trimleft = 0
    electrics.values.trimright = 0
    electrics.values.trimmtngoat_r = 0

    electrics.values.roll = 0
    electrics.values.rollz = 0

    electrics.values.pitch = 0

    electrics.values.brakes = 0

    electrics.values.prop_blur = 0

end


local function flap(VALUE)
    if VALUE == 1 then
        fl = 1 - fl
        electrics.values.flaps = fl
    end
end

local function abrake(VALUE)
    if VALUE == 1 then
        abr = 1 - abr
        electrics.values.airbrake = abr
    end
end

local function updateGFX(dt)




        --print (electrics.values["rpm"])
    
    if electrics.values["rpm"] > 1400 then
        --print (electrics.values["rpm"])
        electrics.values.prop_blur = 1
            
        else
        electrics.values.prop_blur = 0
    
    end

    
    time = time + dt

    --           amplitude                          frequency
    local rbl1 = 0.05       * math.sin(2 * math.pi * 0.5       * time) + offset
    local rbl2 = 0.05       * math.sin(2 * math.pi * 0.8       * time) + offset
    local rbl3 = 0.045      * math.sin(2 * math.pi * 0.7       * time) + offset
    local rbl4 = 0.045      * math.sin(2 * math.pi * 0.3       * time) + offset

    electrics.values.rumble1 = rbl1
    electrics.values.rumble2 = rbl2
    electrics.values.rumble3 = rbl3
    electrics.values.rumble4 = rbl4

    local trim_r = electrics.values.trimmtngoat_r or 0

    trim_r = min(max(trim_r + (electrics.values.trimright * dt * 0.1) - (electrics.values.trimleft * dt * 0.1), -0.5), 0.5)
    electrics.values.rollz = (trim_r) + (electrics.values.roll) + (electrics.values.rumble1) + (electrics.values.rumble2)

    electrics.values.trimmtngoat_r = trim_r

    
      
    local throttle = electrics.values.throttlemtngoat or electrics.values.throttleaxis or 0


    if electrics.values.throttleaxis > 0.02 then
        throttle = electrics.values.throttleaxis
    else
        electrics.values.throttleaxis = 0
        throttle = min(max(throttle + (electrics.values.throttleup * dt * 0.5) - (electrics.values.throttledown * dt * 0.5), 0), 1)
        electrics.values.throttle = throttle
    end


    electrics.values.throttlemtngoat = throttle
    local trim = electrics.values.trimmtngoat or 0

    trim = min(max(trim + (electrics.values.trimup * dt * 0.1) - (electrics.values.trimdown * dt * 0.1), -0.5), 0.5)
    electrics.values.trim = (trim) + (electrics.values.pitch)

    electrics.values.trimmtngoat = trim


    local brakes = electrics.values.brakesmtngoat or 0

    brakes = min(max(brakes + (electrics.values.throttleup * dt * 0.5) - (electrics.values.throttledown * dt * 0.5), 0), 1)
    electrics.values.throttle = throttle

    electrics.values.throttlemtngoat = throttle

    electrics.values.clutch = 0
    electrics.values.clutchRatio = 1
    
end


M.onInit    = onReset
M.onReset   = onReset
M.flap      = flap
M.abrake    = abrake
M.updateGFX = updateGFX



return M