# Simple file triplet checker

$allFiles = Get-ChildItem -File
$pcFiles = ($allFiles | Where-Object {$_.Extension -eq ".pc"}).BaseName
$jsonFiles = ($allFiles | Where-Object {$_.Name -match "^info_(.+)\.json$"}) | ForEach-Object {$_.Name -replace "^info_(.+)\.json$",'$1'}
$imageFiles = ($allFiles | Where-Object {$_.Extension -in ".jpg",".jpeg",".png"}).BaseName

$allNames = ($pcFiles + $jsonFiles + $imageFiles) | Sort-Object -Unique
$missingFiles = @()

foreach ($name in $allNames) {
    $missing = @()
    
    if ($name -notin $pcFiles) { $missing += "$name.pc" }
    if ($name -notin $jsonFiles) { $missing += "info_$name.json" }
    if ($name -notin $imageFiles) { $missing += "$name.jpg" }
    
    if ($missing.Count -gt 0) {
        Write-Host "Missing for $name`: $($missing -join ', ')"
        $missingFiles += $missing
    }
}

if ($missingFiles.Count -eq 0) {
    Write-Host "All triplets complete."
    exit
}

$response = Read-Host "Create dummy files? (y/n)"
if ($response -eq "y") {
    foreach ($file in $missingFiles) {
        Write-Host "Creating: $file"
        if ($file -like "*.pc") {
            New-Item -Path $file -ItemType File -Force | Out-Null
        } elseif ($file -like "info_*.json") {
            Set-Content -Path $file -Value "{}"
        } elseif ($file -like "*.jpg") {
            New-Item -Path $file -ItemType File -Force | Out-Null
        }
    }
}