local M = {}

--CODE FROM DUMMIESMAN

local value = 0

local function onReset()
end

local function getIsEngineRunning()
  return (electrics.values["engineRunning"] or 0) > 0.5
end

local function getGear()
  return electrics.values.gearIndex or 1
end

local function isNaN( v ) return type( v ) == "number" and v ~= v end

local function updateGFX(dt)

  -- things
  -- roughly 1.1mph
  local speedMin = 0.5
  -- roughly 1118mph (too fast!!, might be an instability)
  local speedMax= 500

  -- the actual logic
  if getIsEngineRunning() and getGear() ~= 0 then
	local curSpeed = electrics.values["wheelspeed"] or 0
	if isNaN(curSpeed) then return end -- can't do anything
	if curSpeed > speedMin and curSpeed < speedMax then
	  value = value + ((curSpeed * dt) * 0.001) -- (m/s * time) = distance, * 0.001 = m to km
	end
  end
end

local function getValue()
  return value
end

local function setValue(val)
  value = val
end

-- public interface
M.onInit	  = onInit
M.onReset	  = onReset
M.updateGFX = updateGFX

M.setValue = setValue
M.getValue = getValue

return M