--Modified 2-step lua code
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local engine = nil

local rpmToAV = 0.104719755
local need_to_reset = false
local tempRevLimiterAV = 0
local tempRevLimiterRPM = 0

local function updateGFX(dt)
  if electrics.values['gear'] == "P" or electrics.values['gear'] == "N" then
	engine:setTempRevLimiter(tempRevLimiterAV)
	need_to_reset = true
  elseif need_to_reset == true and electrics.values['gear'] ~= "P" or electrics.values['gear'] == "N" then
	  engine:resetTempRevLimiter()
	  need_to_reset = false
  end
end

local function reset()
  if engine then
	engine:resetTempRevLimiter()
	need_to_reset = false
  end
end

local function init(jbeamData)
  local engineName = jbeamData.engineName or "mainEngine"
  engine = powertrain.getDevice(engineName)
  M.updateGFX = engine and updateGFX or nop

  tempRevLimiterRPM = (jbeamData.rpmLimit or 4000)
  tempRevLimiterAV = tempRevLimiterRPM * rpmToAV

end

M.init = init
M.reset = reset
M.updateGFX = nop

return M
