-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

M.outputPorts = {[1] = true}
M.deviceCategories = {shaft = true}

local abs = math.abs
local clamp = clamp

local torqueSmoother = newTemporalSmoothing(2)
local smoothLinear = 1

local function updateVelocity(device, dt)
  device.inputAV = device[device.outputAVName] * smoothLinear
  device.parent[device.parentOutputAVName] = device.inputAV
end

local function updateTorque(device, dt)
  smoothLinear = clamp(torqueSmoother:get(0, dt), 0, 1)
  device[device.outputTorqueName] = device.parent[device.parentOutputTorqueName] * smoothLinear
end

local function updateTorqueSmoothed(device, dt)
  local outputTorque
  smoothLinear = clamp(torqueSmoother:get(1, dt), 0, 1)
  outputTorque = device.parent[device.parentOutputTorqueName] * smoothLinear
  device[device.outputTorqueName] = outputTorque
end

local function calculateInertia(device)
  local outputInertia = 0
  local cumulativeGearRatio = 1
  local maxCumulativeGearRatio = 1

  if device.children and #device.children > 0 then
    local child = device.children[1]
    outputInertia = child.cumulativeInertia
    cumulativeGearRatio = child.cumulativeGearRatio
    maxCumulativeGearRatio = child.maxCumulativeGearRatio
  else
    outputInertia = device.virtualInertia
  end

  device.cumulativeInertia = outputInertia
  device.invCumulativeInertia = device.cumulativeInertia > 0 and 1 / device.cumulativeInertia or 0
  device.cumulativeGearRatio = cumulativeGearRatio
  device.maxCumulativeGearRatio = maxCumulativeGearRatio
end

local function selectUpdates(device)
  if device.mode == 1 then
    device.velocityUpdate = updateVelocity
    device.torqueUpdate = updateTorqueSmoothed
  elseif device.mode == 0 then
    device.velocityUpdate = updateVelocity
    device.torqueUpdate = updateTorque
  end
end

local function validate(device)
  return true
end

local function setMode(device, mode)
  device.mode = mode
  selectUpdates(device)
end

local function reset(device, jbeamData)
  device.inputAV = 0

  device[device.outputTorqueName] = 0
  device[device.outputAVName] = 0

  selectUpdates(device)

  return device
end

local function new(jbeamData)
  local device = {
    deviceCategories = shallowcopy(M.deviceCategories),
    requiredExternalInertiaOutputs = shallowcopy(M.requiredExternalInertiaOutputs),
    outputPorts = shallowcopy(M.outputPorts),
    name = jbeamData.name,
    type = jbeamData.type,
    inputName = jbeamData.inputName,
    inputIndex = jbeamData.inputIndex,
    inputAV = 0,
    friction = 0,
    mode = 0,
    reset = reset,
    setMode = setMode,
    validate = validate,

    -- dummy shit required by beam
    gearRatio = 1,
    calculateInertia = calculateInertia,
    cumulativeGearRatio = 1,
    maxCumulativeGearRatio = 1,
    cumulativeInertia = 1,
    invCumulativeInertia = 1,
    virtualInertia = 2,
  }

  selectUpdates(device)

  local outputPortIndex = 1

  device.outputTorqueName = "outputTorque" .. tostring(outputPortIndex)
  device.outputAVName = "outputAV" .. tostring(outputPortIndex)
  device[device.outputTorqueName] = 0
  device[device.outputAVName] = 0

  return device
end

M.new = new

return M
