local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local motor = nil
local motors = {}
local powerDisplay = 0
local motorCount = 0
local isMoving = nil
local powerDisplaySmoother = newExponentialSmoothing(30)

local function updateGFX()
    powerDisplay = 0
    motorCount = 0
    isMoving = electrics.values.wheelspeed > 0.1

    for _, em in ipairs(motors) do
        powerDisplay = powerDisplay + (em.throttle or 0) * 1.55 -- this value is dependant on the gauges
        powerDisplay = powerDisplay - (em.regenThrottle or 0) * 0.8 -- this value is dependant on the gauges
        motorCount = motorCount + 1
    end

    powerDisplay = (motorCount > 0 and (powerDisplay / motorCount * (isMoving and 1 or 0)) or 0)
    electrics.values.powerDisplay = powerDisplaySmoother:get(powerDisplay * 3000) + 2400 -- this value is dependant on the gauges

    if motor then
        if motor.regenThrottle ~= 0 and electrics.values.wheelspeed > 0.1 then
            electrics.values.brakelights = 1
        end
    end
end

local function init(jbeamdata)
    powerDisplay = 0
    electrics.values.powerDisplay = 0
    motors = powertrain.getDevicesByType("electricMotor")
    motor = motors[1]
end

M.reset = init
M.init = init
M.updateGFX = updateGFX

return M