-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local conValue = 1
local conversionMultiplierUnit = "ms"
local evMaxSpeed = 0
local throttleThreshold = 0.7
local engineKickIn = 0
local maxPitch = 0.06

local maxBatteryCapacity = 0
local batteriesUsed = {}
local eMotors = {}

local ceDisabled = false
local starterTick = 0
local eDisabled = false
local gear = ""
local evMode = false
local transfercase = nil
local torqueSmoother = nil
local pitchOverwrite = false
local torqueSmoothTimer = 0

local wheelspeed = 0
local throttle = 0
local brake = 0

local defaultRegen = 0
local brakeRegenCoef = 0
local regenThrottleSmoother = newExponentialSmoothing(10)
local currentRegenThrottle = 0

local fullEngineMessageSent = false
local engineFullTakeover = false
local engineRevEngaged = false
local lastIgnition = false

local roll = 0
local pitch = 0
local yaw = 0

local function toggleEvMode()
    if evMode == false then
        evMode = true
        if electrics.values.canUseEV == true then
            guihooks.message("EV Mode enabled", 4, "vehicle.zeitHybrid.evMode", "explicit")
        end
    elseif evMode == true then
        evMode = false
        guihooks.message("EV Mode disabled", 4, "vehicle.zeitHybrid.evMode", "explicit")
        torqueSmoothTimer = 0

    end
end

local function toggleCombustionStarter(bool)
    if electrics.values.ignitionLevel ~= 2 then return end
    if bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            --if ce.ignitionCoef ~= 1 then
                ce:activateStarter(ce)
            --end
            --controller.mainController.setStarter(true)
        end
        --ceDisabled = false
    elseif not bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            --if ce.ignitionCoef ~= 0 then
                ce:deactivateStarter(ce)
            --end
            --controller.mainController.setStarter(false)
        end
        --ceDisabled = true
    end
end

local function toggleCombustion(bool)
    if electrics.values.ignitionLevel ~= 2 then return end
    if bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            ce:enable(ce)
        end
        ceDisabled = false
    elseif not bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            if not ce.isDisabled then
                ce:disable(ce)
            end
        end
        damageTracker.setDamage("engine", "engineDisabled", false) -- overwrite original engine
        ceDisabled = true
    end
end

local function disableCombustionRev()
    electrics.values.engineThrottleFactor = 0
end

local function enableCombustionRev()
    electrics.values.engineThrottleFactor = 1
end

local function setElectricDir(num)
    for _, e in pairs (eMotors) do
        e.motorDirection = num
    end
end

local function init(jbeamData)
    electrics.values.canUseEV = false
    transfercase = powertrain.getDevice("transfercase") -- this is required for EV Mode
    torqueSmoother = powertrain.getDevice("torqueSmoother") -- this is required for EV Mode
    ceDisabled = false
    eDisabled = false
    gear = ""
    evMode = false
    pitchOverwrite = false
    wheelspeed = 0
    throttle = 0
    brake = 0
    roll = 0
    pitch = 0
    yaw = 0
    torqueSmoothTimer = 0

    -- jbeam stuff
    defaultRegen = jbeamData.defaultRegen or 0.2
    brakeRegenCoef = jbeamData.brakeRegenCoef or 0.3
    conversionMultiplierUnit = jbeamData.conversionMultiplierUnit or "ms"
    evMaxSpeed = jbeamData.evMaxSpeed or 8.3
    throttleThreshold = jbeamData.throttleThreshold or 0.7
    engineKickIn = jbeamData.engineKickIn or 8.3
    maxPitch = jbeamData.maxPitch or 0.06

    if conversionMultiplierUnit == "ms" then
        conValue = 1
    elseif conversionMultiplierUnit == "mph" then
        conValue = 2.23694
    elseif conversionMultiplierUnit == "kmh" then
        conValue = 3.6
    end

    -- battery stuff
    electrics.values.currentbatteryChargeHybrid = 0
    eMotors = powertrain.getDevicesByType("electricMotor")
    for _, v in pairs(eMotors) do
      for _, j in pairs(v.registeredEnergyStorages) do
        batteriesUsed[j] = true
      end
    end

    for k, _ in pairs(batteriesUsed) do
      local storage = energyStorage.getStorage(k)
      maxBatteryCapacity = maxBatteryCapacity + storage.energyCapacity
    end
end

local function reset()
    electrics.values.canUseEV = false
    transfercase = powertrain.getDevice("transfercase") -- this is required for EV Mode
    torqueSmoother = powertrain.getDevice("torqueSmoother") -- this is required for EV Mode
    ceDisabled = false
    eDisabled = false
    gear = ""
    evMode = false
    pitchOverwrite = false
    wheelspeed = 0
    throttle = 0
    brake = 0
    roll = 0
    pitch = 0
    yaw = 0
    torqueSmoothTimer = 0
end

local function updateGFX(dt)
    -- general required stuff
    local energyLeft = 0
    for k, _ in pairs(batteriesUsed) do
      local storage = energyStorage.getStorage(k)
      energyLeft = energyLeft + storage.storedEnergy
    end
    local energyLeftPercent = math.floor(energyLeft / maxBatteryCapacity * 100)
    electrics.values.currentbatteryChargeHybrid = energyLeft / maxBatteryCapacity

    -- electrics.values.running = true -- force lock to true -- update 0.27: no longer needed
    -- electrics.values.ignition = true -- force lock to true, for gauges -- update 0.27: no longer needed

    if electrics.values.ignitionLevel ~= lastIgnition then
        for _, motor in ipairs(eMotors) do
            motor:setIgnition((electrics.values.ignitionLevel == 2) and 1 or 0)
        end
    end
    lastIgnition = electrics.values.ignitionLevel

    gear = electrics.values.gear
    roll, pitch, yaw = obj:getRollPitchYaw()

    wheelspeed = electrics.values.wheelspeed
    throttle = electrics.values.throttle
    brake = electrics.values.brake

    -- pitch check
    if pitch > maxPitch then
        pitchOverwrite = true
        evMode = false
    else
        pitchOverwrite = false
    end

    -- check if we can use ev mode
    electrics.values.canUseEV = wheelspeed * conValue < evMaxSpeed and not pitchOverwrite and electrics.values.ignitionLevel == 2

    -- taken from shiftLogic-electricMotor to allow for regen
    local regenThrottle = throttle <= 0 and math.min(defaultRegen + brake * brakeRegenCoef, 1) or 0
    local emergencyBrakeCoef = brake >= 1 and 0.5 or 1
    local escCoef = electrics.values.escActive and 0 or 1
    local steeringCoef = math.abs(sensors.gx2) > 5 and 0 or 1
    currentRegenThrottle = regenThrottle * escCoef * steeringCoef * emergencyBrakeCoef
    local smoothedRegenThrottle = regenThrottleSmoother:get(currentRegenThrottle)
    if smoothedRegenThrottle < 0.1 then
        electrics.values.regenThrottle = 0
    else
        electrics.values.regenThrottle = regenThrottleSmoother:get(currentRegenThrottle)
    end
    --

    torqueSmoothTimer = torqueSmoothTimer + 0.1

    starterTick = starterTick + dt
    if starterTick >= 2 then
        if ceDisabled == false and electrics.values.rpm < 50 then
            toggleCombustionStarter(true)
        elseif ceDisabled == true and electrics.values.rpm > 50 then
            toggleCombustionStarter(false)
        end
        starterTick = 0
    end
    if not evMode and energyLeftPercent >= 10 and not engineFullTakeover then -- logic for normal not ev mode
        if torqueSmoothTimer >= 8 then
            torqueSmoother.setMode(torqueSmoother, 1)
            torqueSmoothTimer = 9
        end
        transfercase.setMode(transfercase, "connected")
        fullEngineMessageSent = false
        -- emotor logic
        if gear == "N" or gear == "P" then
            setElectricDir(0)
        elseif gear == "R" then
            setElectricDir(-1)
        elseif gear == "D" or gear == "S" then
            setElectricDir(1)
        end
        -- combustion logic
        if gear == "R" then -- disable combustion motor in R
            toggleCombustion(false)
            ceDisabled = true
            torqueSmoother.setMode(torqueSmoother, 0)
        elseif gear == "P" then -- disable combustion motor in P but have it connected
            toggleCombustion(false)
            ceDisabled = true
            torqueSmoother.setMode(torqueSmoother, 1)
        else
            if wheelspeed <= 2*conValue and engineRevEngaged then
                engineRevEngaged = false -- consider it stopped
            end
            if ceDisabled == true then
                toggleCombustion(true)
                toggleCombustionStarter(true)
            end
            if (wheelspeed * conValue > engineKickIn or (throttle > throttleThreshold)) or pitchOverwrite then
                enableCombustionRev()
                transfercase.setMode(transfercase, "connected")
                torqueSmoother.setMode(torqueSmoother, 1)
                engineRevEngaged = true
            elseif not engineRevEngaged then
                disableCombustionRev()
                transfercase.setMode(transfercase, "disconnected")
                torqueSmoother.setMode(torqueSmoother, 0)
            end
        end
    elseif evMode and not pitchOverwrite then -- logic for ev mode
        if electrics.values.wheelspeed * conValue > evMaxSpeed then
            torqueSmoothTimer = 0
            evMode = false
            guihooks.message("EV Mode disabled", 2, "vehicle.zeitHybrid.evMode", "explicit")
        elseif energyLeftPercent <= 20 then
            torqueSmoothTimer = 0
            evMode = false
            guihooks.message("EV Mode unavailable due to low charge...", 4, "vehicle.zeitHybrid.evMode", "explicit")
        end
        fullEngineMessageSent = false
        if not evMode then return end -- additional lock

        torqueSmoothTimer = 0
        transfercase.setMode(transfercase, "disconnected")
        torqueSmoother.setMode(torqueSmoother, 0)
        ceDisabled = true
        toggleCombustion(false)
        electrics.values.checkengine = false

        if gear == "N" or gear == "P" then
            setElectricDir(0)
        elseif gear == "R" then
            setElectricDir(-1)
        elseif gear == "D" or gear == "S" then
            setElectricDir(1)
        end
    else -- default logic, applies if battery is too low
        if not fullEngineMessageSent then guihooks.message("Engine fully taking over due to low charge...", 4, "vehicle.zeitHybrid.engineTakeOver", "explicit") end
        fullEngineMessageSent = true

        transfercase.setMode(transfercase, "connected")
        torqueSmoother.setMode(torqueSmoother, 1)
        enableCombustionRev()
        ceDisabled = false
        toggleCombustion(true)
        if throttle == 0 then
            setElectricDir(1)
        else
            setElectricDir(0)
        end

        if energyLeftPercent >= 30 then
            engineFullTakeover = false
            guihooks.message("Electric motor engaged again...", 4, "vehicle.zeitHybrid.engineTakeOver", "explicit")
        else
            engineFullTakeover = true
        end
    end
end

-- specific public stuff
M.toggleEvModeZeit = toggleEvMode

-- general public stuff
M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M