local M = {}
M.type = "auxiliary"

local newThrottleFactor = 1
local throttleFactorSmoother = newExponentialSmoothing(4)

local function updateGFX()
    if electrics.values.airspeed < 5 and ((electrics.values.wheelspeed < 0.2 and electrics.values.wheelspeed > 0.01) or electrics.values.throttle > 0.95) then
        newThrottleFactor = 0.95
    else
        newThrottleFactor = 1
    end

    --print(electrics.values.throttleFactorFront)

    electrics.values.throttleFactorFront = throttleFactorSmoother:get(newThrottleFactor)
end

local function init()
end

local function reset()
end

-- public interface
M.updateGFX = updateGFX
M.init = init
M.reset = reset


return M