-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local leftIsOn = false
local rightIsOn = false
local corneringSmootherL = newTemporalSigmoidSmoothing(15, 20)
local corneringSmootherR = newTemporalSigmoidSmoothing(15, 20)

local function updateGFX(dt)
  if not playerInfo.anyPlayerSeated then return end -- breaks stuff otherwise, we also dont need it on ai anyway

  if electrics.values.fog == 0 then
    if ((electrics.values.wheelspeed > 13.4 and electrics.values.wheelspeed < 0.1) and (electrics.values.signal_left_input == 0 and electrics.values.signal_right_input == 0)) or electrics.values.lowhighbeam == 0 then
      leftIsOn = false
      rightIsOn = false
    else
      rightIsOn = electrics.values.steering < -70 or (electrics.values.signal_right_input == 1 and electrics.values.wheelspeed < 8.333 and electrics.values.hazard_enabled == 0)
      leftIsOn = electrics.values.steering > 70 or (electrics.values.signal_left_input == 1 and electrics.values.wheelspeed < 8.333 and electrics.values.hazard_enabled == 0)
    end
  else
    leftIsOn = true
    rightIsOn = true
  end

  electrics.values.cornering_L = corneringSmootherL:get(leftIsOn and 1 or 0, dt)
  electrics.values.cornering_R = corneringSmootherR:get(rightIsOn and 1 or 0, dt)
end

local function reset()
  leftIsOn = false
  rightIsOn = false
end

local function init()
end

M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M
