-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['func'] = 0
    electrics.values['func_input'] = 0
    electrics.values['fork'] = 0
    electrics.values['fork_input'] = 0
    electrics.values['fork2'] = 0
    electrics.values['fork2_input'] = 0
    
end


local function updateGFX(dt)

    electrics.values['func'] = math.min(1, math.max(-0.0, (electrics.values['func'] + electrics.values['func_input'] * dt * 0.6)))
     electrics.values['fork'] = math.min(1, math.max(-0.6, (electrics.values['fork'] + electrics.values['fork_input'] * dt * 0.6)))
     electrics.values['fork2'] = math.min(1, math.max(-0.0, (electrics.values['fork2'] + electrics.values['fork2_input'] * dt * 0.6)))
     
end




-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
