-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['rotate'] = 0
    electrics.values['rotate_input'] = 0
end


local function updateGFX(dt)
    electrics.values['rotate'] = math.min(1, math.max(-1.0, (electrics.values['rotate'] + electrics.values['rotate_input'] * dt * 0.6)))
end



-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
