-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['arm'] = 0
    electrics.values['arm_input'] = 0
    electrics.values['arm_tilt'] = 0
    electrics.values['arm_tilt_input'] = 0
    electrics.values['func'] = 0
    electrics.values['func_input'] = 0
    electrics.values['beacons'] = 0

end



local function updateGFX(dt)
    electrics.values['arm'] = math.min(1, math.max(-0.08, (electrics.values['arm'] + electrics.values['arm_input'] * dt * 0.6)))
    electrics.values['arm_tilt'] = math.min(1, math.max(-0, (electrics.values['arm_tilt'] - electrics.values['arm_tilt_input'] * dt * 0.6)))
    electrics.values['func'] = math.min(1, math.max(-0.0, (electrics.values['func'] + electrics.values['func_input'] * dt * 0.6)))
    
end



-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
