-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['reel_lift'] = 0
    electrics.values['reel_slide'] = 0
    electrics.values['reel_lift_input'] = 0
    electrics.values['reel_slide_input'] = 0
    electrics.values['treshing'] = 0
    electrics.values['beacons'] = 0

end





local function updateGFX(dt)
    electrics.values['reel_lift'] = math.min(1, math.max(-0.0, (electrics.values['reel_lift'] + electrics.values['reel_lift_input'] * dt * 1.0)))
    electrics.values['reel_slide'] = math.min(1, math.max(-0.0, (electrics.values['reel_slide'] - electrics.values['reel_slide_input'] * dt * 1.0)))
 
end

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
electrics.values.func3 = 0
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId)
electrics.values.func3 = 0
end



-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

return M
