-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['back_hitch_tilt'] = 0
    electrics.values['beacons'] = 0
    electrics.values['back_hitch_tilt_input'] = 0
    electrics.values['back_hitch'] = 0
    electrics.values['back_hitch_input'] = 0

    electrics.values['upperlink'] = 0

end



local function updateGFX(dt)
   
    electrics.values['back_hitch_tilt'] = math.min(1, math.max(-0.0, (electrics.values['back_hitch_tilt'] - electrics.values['back_hitch_tilt_input'] * dt * 0.6)))
    electrics.values['back_hitch'] = math.min(1, math.max(-0.2, (electrics.values['back_hitch'] + electrics.values['back_hitch_input'] * dt * 0.6)))


    
end

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
electrics.values.func3 = 0
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId)
electrics.values.func3 = 0
end




-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

return M
