local M = {}

local function togglesplitShaft()
  if not powertrain then
    log("E", "splitShaft", "Powertrain is not available!")
    return
  end

  local devices = powertrain.getDevices()
  for _, v in pairs(devices) do
    if v.type == "dw_probug_splitShaft" and v.defaultToggle then
      log("I", "splitShaft", "Toggling device: " .. v.name)
      powertrain.toggleDeviceMode(v.name)  -- safer
    end
  end
end

-- Expose the function to the game
M.togglesplitShaft = togglesplitShaft

-- Optional: call automatically on reset
local function onReset()
  togglesplitShaft()
end



return M