-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

M.isForcedOpen = false
M.isOpened = false
M.cooldown = 0.0
M.airSpeed = 0.0
electrics.values.meosRoofParachute = -1
electrics.values.meosRoofParachuteFB = 0

local function toggle()
	if M.cooldown <= 0 then
		if M.isForcedOpen then
			M.openChute()
		elseif M.isOpened then
			M.closeChute()
		else
			M.airSpeed = electrics.values.airspeed or 0
			if M.airSpeed > 5 then
				M.openChute()
				--log("I", "", "Parachute Opened")
			end
		end
	end
end

local function forceToggle()
	if M.cooldown <= 0 then
		M.isForcedOpen = not M.isForcedOpen
		M.toggle()
	end
end

local function checkSpeed()
	--log("I", "", "Speed Checked")
    M.airSpeed = electrics.values.airspeed or 0
    if M.isOpened and M.airSpeed < 5 then
		M.closeChute()
		log("I", "", "Parachute closed (Low speed)")
    end
end

local function openChute()
	electrics.values.meosRoofParachute = 1
	M.cooldown = 1.5
	M.isOpened = true
end

local function closeChute()
	electrics.values.meosRoofParachute = -1
	M.isForcedOpen = false
	M.isOpened = false
	M.cooldown = 1.5
end

local function updateGFX(dt)
	electrics.values.meosRoofParachuteFB = 0
	if M.isOpened then
		electrics.values.meosRoofParachuteFB = 1
	end
	if not M.isForcedOpen and M.isOpened then
		M.checkSpeed()
    end
	if M.cooldown > 0.0 then
		M.cooldown = M.cooldown - dt
		electrics.values.meosRoofParachuteFB = 1
	end
end

M.updateGFX = updateGFX

local function init()
    M.onReset()
end

local function reset()
	--log("I", "", "Parachute Closed")
    M.closeChute()
	M.cooldown = 0.0
end

M.toggle = toggle
M.closeChute = closeChute
M.openChute = openChute
M.forceToggle = forceToggle
M.checkSpeed = checkSpeed
M.onReset = reset
M.onInit = init

return M
