-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local min = math.min
local max = math.max

local gaugesScreenName = nil
local htmlPath = nil

local updateServiceTimer = 0
local updateFPS = 20
local unitType
local unitTypeTemp

local function serviceRequired()
  for _, device in pairs (powertrain.getDevices()) do
    if damageTracker.getDamage("powertrain", tostring(device.name)) then
      return true
    end
  end
  for _, storage in pairs (energyStorage.getStorages()) do
    if damageTracker.getDamage("energyStorage", tostring(storage.name)) then
      return true
    end
  end

  if damageTracker.getDamage("engine", "oilpanLeak") then return true
  elseif damageTracker.getDamage("engine", "oilRadiatorLeak") then return true
  elseif damageTracker.getDamage("engine", "headGasketDamaged") then return true
  elseif damageTracker.getDamage("engine", "pistonRingsDamaged") then return true
  elseif damageTracker.getDamage("engine", "rogBearingsDamaged") then return true
  elseif damageTracker.getDamage("engine", "blockMelted") then return true
  elseif damageTracker.getDamage("engine", "cylinderWallsMelted") then return true
  elseif damageTracker.getDamage("engine", "radiatorLeak") then return true
  elseif damageTracker.getDamage("engine", "exhaustBroken") then return true
  elseif damageTracker.getDamage("engine", "inductionSystemDamaged") then return true
  elseif damageTracker.getDamage("engine", "superchargerDamaged") then return true
  elseif damageTracker.getDamage("engine", "turbochargerDamaged") then return true
  elseif damageTracker.getDamage("engine", "engineTorqueReduced") then return true
  elseif damageTracker.getDamage("engine", "impactDamage") then return true
  elseif damageTracker.getDamage("engine", "catastrophicOverrevDamaged") then return true
  elseif damageTracker.getDamage("engine", "mildOverrevDamage") then return true
  elseif damageTracker.getDamage("engine", "engineDisabled") then return true
  elseif damageTracker.getDamage("engine", "engineLockedUp") then return true
  elseif damageTracker.getDamage("engine", "energyStorage") then return true
  end

  -- if all fail, return false
  return false
end

local data = {}
local function updateGFX(dt)
  updateServiceTimer = updateServiceTimer + dt

  if playerInfo.anyPlayerSeated and obj:getUpdateUIflag() then
    local wheelspeed = electrics.values.wheelspeed or 0
    data.gear = electrics.values.gear
    if data.gear == 0 then
      data.gear = "N"
    elseif data.gear == -1 then
      data.gear = "R"
    end

    data.temp = obj:getEnvTemperature() - 273.15
    --if tonumber(os.date("%H")) then -- because 12h format
    --  data.time = "0"..tonumber(os.date("%H")) - 12 .. ":" .. os.date("%M")
    --  data.timeUnit = "pm"
    --else
      data.time = os.date("%H") .. ":" .. os.date("%M")
    --  data.timeUnit = "am"
    --end
    data.speed = wheelspeed
    data.oiltemp = math.ceil(electrics.values.oiltemp) or 0
    data.odometer = electrics.values.e60_odo or 0
    data.tripOdometer = electrics.values.e60_tripodo or 0
    data.shiftUp = electrics.values.shiftUpLight or 0
    data.running = electrics.values.running
    if updateServiceTimer >= 3 then
      data.serviceRequired = serviceRequired()
      updateServiceTimer = 0
    end
    --dump(data)

    htmlTexture.call(gaugesScreenName, "updateData", data)
  end
end

local function onInit()
  gaugesScreenName = "@e60_display"
  htmlPath = "local://local/vehicles/e60/gauge_display/e60_display.html"
  local width = 256
  local height = 256

  if not gaugesScreenName then
    log("E", "e60GaugeScreen", "Got no material name for the texture, can't display anything...")
    M.updateGFX = nop
  else
    if htmlPath then
      htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    else
      log("E", "e60GaugeScreen", "Got no html path for the texture, can't display anything...")
      M.updateGFX = nop
    end
  end
end

local function onReset()
  unitType = settings.getValue("uiUnitLength") or "metric" -- use player settings
  unitTypeTemp = settings.getValue("uiUnitTemperature") or "c"
  if gaugesScreenName then
    htmlTexture.call(gaugesScreenName, "setUnits", {unitType = unitType, unitTypeTemp = unitTypeTemp})
  end
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M