local M = {}

local lockFL = nil
local lockFR = nil
local lockRL = nil
local lockRR = nil

local unlockFL = nil
local unlockFR = nil
local unlockRL = nil
local unlockRR = nil

local playLockTime = 1

local lockVolum = 0.25
local eleVolum = 1

local lastLockState = {
	FL = 0,
	FR = 0,
	RL = 0,
	RR = 0
}

local timer = {
	LFL = playLockTime,
	LFR = playLockTime,
	LRL = playLockTime,
	LRR = playLockTime,
	UFL = playLockTime,
	UFR = playLockTime,
	URL = playLockTime,
	URR = playLockTime
}

local function playSoundOnceAtNode(soundName, nodeID, volume)
    local snd = GameEngine:playSFXOnce(soundName)
    snd:setVolume(volume)
    obj:attachSFXNode(snd, nodeID)
end

local function updateGFX(dt)

	-- log("D", "sigL", electrics.values.sigL)
	-- log("D", "signal_L", electrics.values.signal_L)

	timer.LFL = math.min(timer.LFL + dt, playLockTime)
	timer.LFR = math.min(timer.LFR + dt, playLockTime)
	timer.LRL = math.min(timer.LRL + dt, playLockTime)
	timer.LRR = math.min(timer.LRR + dt, playLockTime)

	timer.UFL = math.min(timer.UFL + dt, playLockTime)
	timer.UFR = math.min(timer.UFR + dt, playLockTime)
	timer.URL = math.min(timer.URL + dt, playLockTime)
	timer.URR = math.min(timer.URR + dt, playLockTime)

	if timer.LFL == playLockTime then
		obj:setVolume(lockFL, 0)
		obj:stopSFX(lockFL)
	end
	if timer.LFR == playLockTime then
		obj:setVolume(lockFR, 0)
		obj:stopSFX(lockFR)
	end
	if timer.LRL == playLockTime then
		obj:setVolume(lockRL, 0)
		obj:stopSFX(lockRL)
	end
	if timer.LRR == playLockTime then
		obj:setVolume(lockRR, 0)
		obj:stopSFX(lockRR)
	end

	if timer.UFL == playLockTime then
		obj:setVolume(unlockFL, 0)
		obj:stopSFX(unlockFL)
	end
	if timer.UFR == playLockTime then
		obj:setVolume(unlockFR, 0)
		obj:stopSFX(unlockFR)
	end
	if timer.URL == playLockTime then
		obj:setVolume(unlockRL, 0)
		obj:stopSFX(unlockRL)
	end
	if timer.URR == playLockTime then
		obj:setVolume(unlockRR, 0)
		obj:stopSFX(unlockRR)
	end

	if lastLockState.FL == 0 and electrics.values.ifLock0 == 1 then
		obj:cutSFX(lockFL)
		obj:setVolume(lockFL, lockVolum)
		obj:playSFX(lockFL)
		-- playSoundOnceAtNode("art/sound/lock/lock.mp3", 4, 1)
		lastLockState.FL = electrics.values.ifLock0
		timer.LFL = 0
	elseif lastLockState.FL == 1 and electrics.values.ifLock0 == 0 then
		obj:cutSFX(unlockFL)
		obj:setVolume(unlockFL, lockVolum)
		obj:playSFX(unlockFL)
		lastLockState.FL = electrics.values.ifLock0
		timer.UFL = 0
	end

	if lastLockState.FR == 0 and electrics.values.ifLock1 == 1 then
		obj:cutSFX(lockFR)
		obj:setVolume(lockFR, lockVolum)
		obj:playSFX(lockFR)
		lastLockState.FR = electrics.values.ifLock1
		timer.LFR = 0
	elseif lastLockState.FR == 1 and electrics.values.ifLock1 == 0 then
		obj:cutSFX(unlockFR)
		obj:setVolume(unlockFR, lockVolum)
		obj:playSFX(unlockFR)
		lastLockState.FR = electrics.values.ifLock1
		timer.UFR = 0
	end

	if lastLockState.RL == 0 and electrics.values.ifLock2 == 1 then
		obj:cutSFX(lockRL)
		obj:setVolume(lockRL, lockVolum)
		obj:playSFX(lockRL)
		lastLockState.RL = electrics.values.ifLock2
		timer.LRL = 0
	elseif lastLockState.RL == 1 and electrics.values.ifLock2 == 0 then
		obj:cutSFX(unlockRL)
		obj:setVolume(unlockRL, lockVolum)
		obj:playSFX(unlockRL)
		lastLockState.RL = electrics.values.ifLock2
		timer.URL = 0
	end

	if lastLockState.RR == 0 and electrics.values.ifLock3 == 1 then
		obj:cutSFX(lockRR)
		obj:setVolume(lockRR, lockVolum)
		obj:playSFX(lockRR)
		lastLockState.RR = electrics.values.ifLock3
		timer.LRR = 0
	elseif lastLockState.RR == 1 and electrics.values.ifLock3 == 0 then
		obj:cutSFX(unlockRR)
		obj:setVolume(unlockRR, lockVolum)
		obj:playSFX(unlockRR)
		lastLockState.RR = electrics.values.ifLock3
		timer.URR = 0
	end

end

local function init()
	
	-- for v, node in pairs (v.data.nodes) do	--for finding out the node ID
	-- 	if node.name == "d14lll" then
	-- 		lockNode = v
	-- 	end
	-- end

	local lock = "art/sound/lock/lock.mp3"
	local unlock = "art/sound/lock/lock.mp3"
	
	-- FL 4
	-- FR 7
	-- RL 9
	-- RR 11
	lockFL = obj:createSFXSource2(lock, "AudioDefaultLoop3D", "", 4, 0)
	lockFR = obj:createSFXSource2(lock, "AudioDefaultLoop3D", "", 7, 0)
	lockRL = obj:createSFXSource2(lock, "AudioDefaultLoop3D", "", 9, 0)
	lockRR = obj:createSFXSource2(lock, "AudioDefaultLoop3D", "", 11, 0)
	obj:stopSFX(lockFL)
	obj:stopSFX(lockFR)
	obj:stopSFX(lockRL)
	obj:stopSFX(lockRR)

	unlockFL = obj:createSFXSource2(unlock, "AudioDefaultLoop3D", "", 4, 0)
	unlockFR = obj:createSFXSource2(unlock, "AudioDefaultLoop3D", "", 7, 0)
	unlockRL = obj:createSFXSource2(unlock, "AudioDefaultLoop3D", "", 9, 0)
	unlockRR = obj:createSFXSource2(unlock, "AudioDefaultLoop3D", "", 11, 0)
	obj:stopSFX(unlockFL)
	obj:stopSFX(unlockFR)
	obj:stopSFX(unlockRL)
	obj:stopSFX(unlockRR)

end

local function onReset()
	lastLockState.FL = 0
	lastLockState.FR = 0
	lastLockState.RL = 0
	lastLockState.RR = 0
end

M.onInit = init
M.onReset    = onReset
M.init = init
M.reset = onReset
M.updateGFX = updateGFX


return M