-- Code by SineMatic(YT)
-- If you want to use this code, let me know

-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

-- coefficients of this smoothing function: value = k*(x-t)^4 + n
local stalkSmootherTime = 1 -- t. Default, rewritten by jbeamData
local counter = 0 -- x.
local k -- k.
local n -- n.
local currentStalkPosition
local targetStalkPosition
local pendingStalkUpdate = false
local smootherCoefSet = false

-- constants
local pi = 3.14159
local rearWiperPresent = false
local frontWipersPresent = false
local frontWipersVolume = 1 -- default, rewritten by jbeamData
local rearWiperVolume = 1 -- default, rewritten by jbeamData
local triggerID_front
local triggerPosDiff_front = vec3(0, 0, 0)
local triggerPosDiff_rear = vec3(0, 0, 0)
local triggerPosDiff_digidisp = vec3(0, 0, 0)

-- vars for sound objects
local sfx_wipers
local sfx_rear_wiper
local sfx_wiper_stalk
local sfx_rear_wiper_stalk

-- vars for rear wiper position calculation
electrics.values.wiperValR = 0
local periodR = 0
local modeR = 0
local pendingOffR = false

-- vars for front wipers position calculation
local wiperSpeed = 0
electrics.values.wipers_position = 0
electrics.values.wiperstalk = 0
local period = 0
local mode = 0
local pendingOff = false

local function resetValues()
  electrics.values.wipers_position = 0
  electrics.values.wiperstalk = 0
  period = 0
  mode = 0
  pendingOff = false
end

local function resetValuesR()
  electrics.values.wiperValR = 0
  periodR = 0
  modeR = 0
  pendingOffR = false
end

local function init(jbeamData)
  rearWiperPresent = jbeamData.rearWiperPresent
  frontWipersPresent = jbeamData.frontWipersPresent
  frontWipersVolume = jbeamData.frontWipersVolume or 1
  rearWiperVolume = jbeamData.rearWiperVolume or 1
  resetValues()
  resetValuesR()
  
  stalkSmootherTime = jbeamData.stalkSmootherTime or 1
  triggerPosDiff_front = vec3(jbeamData.triggerPosDiff_front[1], jbeamData.triggerPosDiff_front[2], jbeamData.triggerPosDiff_front[3]) or vec3(0, 0, 0)
  triggerPosDiff_rear = vec3(jbeamData.triggerPosDiff_rear[1], jbeamData.triggerPosDiff_rear[2], jbeamData.triggerPosDiff_rear[3]) or vec3(0, 0, 0)
  triggerPosDiff_digidisp = vec3(jbeamData.triggerPosDiff_digidisp[1], jbeamData.triggerPosDiff_digidisp[2], jbeamData.triggerPosDiff_digidisp[3]) or vec3(0, 0, 0)
  for key, triggerData in pairs(v.data.triggers) do
    if triggerData["name"] == "wiper_stalk_front" then
      triggerID_front = triggerData["abid"]
    end
    if triggerData["name"] == "wiper_stalk_rear" then
      triggerID_rear = triggerData["abid"]
    end    
	if triggerData["name"] == "digi_disp_mode" then
      triggerID_digidisp = triggerData["abid"]
    end
  end
end

local function reset()
  resetValues()
  resetValuesR()
end

local function toggleMode()
  if not frontWipersPresent then return end
  sfx_wiper_stalk = sfx_wiper_stalk or sounds.createSoundscapeSound("indicatorStart")
  sfx_wipers = sfx_wipers or sounds.createSoundscapeSound("frontWipers")
  local modeTemp = (mode + 1) % 4
  if modeTemp == 0 then
    pendingOff = true
    period = period % (2*pi)
  else
    mode = modeTemp
    wiperSpeed = 2 + 3 * math.ceil(mode/2, 1)
    if electrics.values.wipers_position == 0 then
      if period > 2*pi then
        period = 0
      end
      sounds.playSoundSkipAI(sfx_wipers, frontWipersVolume)
    end
  end
  guihooks.message("Wiper mode: "..modeTemp)
  sounds.playSoundSkipAI(sfx_wiper_stalk)
  
  smootherCoefSet = false
  pendingStalkUpdate = true
  targetStalkPosition = modeTemp
  currentStalkPosition = electrics.values.wiperstalk
end

local function toggleModeR()
  if not rearWiperPresent then return end
  local modeRtemp = (modeR + 1) % 2
  guihooks.message("Rear wiper mode: "..modeRtemp)
  if modeRtemp == 0 then
    pendingOffR = true
  else
    modeR = 1
    if electrics.values.wiperValR == 0 then
      periodR = 0
    end
    sfx_rear_wiper = sfx_rear_wiper or sounds.createSoundscapeSound("rearWiper")
    sounds.playSoundSkipAI(sfx_rear_wiper, rearWiperVolume)
  end
  sfx_rear_wiper_stalk = sfx_rear_wiper_stalk or sounds.createSoundscapeSound("rearWiperStalk")
  sounds.playSoundSkipAI(sfx_rear_wiper_stalk)
end

local function calculatePosition(mode, period, electricName)
  if mode == 1 and period > 2*pi then
    electrics.values[electricName] = 0
  else
    electrics.values[electricName] = (1 - math.cos(period))/2
  end
end

local function updateStalk(dt)
  if not smootherCoefSet then
    counter = 0
    k = (currentStalkPosition - targetStalkPosition) / stalkSmootherTime ^ 4
    n = targetStalkPosition
    smootherCoefSet = true
  end
  
  counter = counter + dt
  currentStalkPosition = k * (counter - stalkSmootherTime)^4 + n
  
  if counter > stalkSmootherTime then
    pendingStalkUpdate = false
    smootherCoefSet = false
    electrics.values.wiperstalk = targetStalkPosition
  else
    electrics.values.wiperstalk = currentStalkPosition
  end
  
  -- the following code translates/rotates trigger boxes/spheres
  local state = electrics.values.wiperstalk / 3
  if triggerID_front then
    local triggerPos_front = state * triggerPosDiff_front
    local triggerPos_front_string = "vec3("..tostring(triggerPos_front.x)..","..tostring(triggerPos_front.y)..","..tostring(triggerPos_front.z)..")"
    obj:queueGameEngineLua([[
      local trgFront = be:getObjectByID(]]..tostring(obj:getId())..[[):getTrigger(]]..tostring(triggerID_front)..[[) 
      trgFront:update(]]..triggerPos_front_string..[[, vec3(0, 0, 0), true, 0)
    ]])
  end
  if triggerID_rear then
    local triggerPos_rear = state * triggerPosDiff_rear
    local triggerPos_rear_string = "vec3("..tostring(triggerPos_rear.x)..","..tostring(triggerPos_rear.y)..","..tostring(triggerPos_rear.z)..")"
    obj:queueGameEngineLua([[
      local trgRear = be:getObjectByID(]]..tostring(obj:getId())..[[):getTrigger(]]..tostring(triggerID_rear)..[[) 
      trgRear:update(]]..triggerPos_rear_string..[[, vec3(0, 0, 0), true, 0) 
    ]])
  end  
  if triggerID_digidisp then
    local triggerPos_digidisp = state * triggerPosDiff_digidisp
    local triggerPos_digidisp_string = "vec3("..tostring(triggerPos_digidisp.x)..","..tostring(triggerPos_digidisp.y)..","..tostring(triggerPos_digidisp.z)..")"
    obj:queueGameEngineLua([[
      local trgRear = be:getObjectByID(]]..tostring(obj:getId())..[[):getTrigger(]]..tostring(triggerID_digidisp)..[[) 
      trgRear:update(]]..triggerPos_digidisp_string..[[, vec3(0, 0, 0), true, 0) 
    ]])
  end
end

local function updateGFX(dt)
  if mode ~= 0 then
    if pendingOff and period > 2*pi then
      resetValues()
    end
    period = (period + dt*wiperSpeed)
    calculatePosition(mode, period, "wipers_position")
    if mode == 1 then
      if period > 6*pi then
        period = period % (6*pi)
        sounds.playSoundSkipAI(sfx_wipers, frontWipersVolume)
      end
    else 
      if period > 2*pi then
        if pendingOff then
          resetValues()
          goto continue
        end
        period = period % (2*pi)
        sounds.playSoundSkipAI(sfx_wipers, frontWipersVolume)
      end
      ::continue::
    end
  end
  
  if modeR ~= 0 then
    if pendingOffR and periodR > 2*pi then
      resetValuesR()
    end
    periodR = (periodR + dt*5)
    calculatePosition(modeR, periodR, "wiperValR")
    if periodR > 6*pi then
      periodR = periodR % (6*pi)
      sounds.playSoundSkipAI(sfx_rear_wiper, rearWiperVolume)
    end
  end
  
  if pendingStalkUpdate then
    updateStalk(dt)
  end
end

M.init = init
M.reset = reset
M.toggleMode = toggleMode
M.toggleModeR = toggleModeR
M.updateGFX = updateGFX

return M