local M = {}
local lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
local lastErrorAISteer  = 0
local IntegralSumManualSteer = 0 --Integral sum, 
local IntegralSumAISteer = 0
local minimumLoggingInterval =  0.125 -- 8 times per second by default
local runningTimer = 0
local timeSinceLastLog = 0
local logFile = nil
local enableLogToFile = 0
local enableLogSteering = 0
local enableAILog = 0
local wheelingMeasure = 0





local throttleArray = nil
local clutchArray = nil
local steerArray = nil
local posArray = nil

local gearIndexArray = nil
local current_AI_index = 0
local recorded_AI_index = 0
local current_AI_state = 0
local currentGear = 0
local lastPosition = 0
local AI_STATE_STOPPED = 0
local AI_STATE_RECORDING = 1
local AI_STATE_PLAYING = 2
local MAX_AI_ELEMS = 2000000

local KEYB_STEER_INC = 0.005
local KEYB_INPUT = 0
local WHEEL_INPUT = 1
local inputMethod = KEYB_METHOD


local AutoThrottle
local THROTTLE_ALGO_START_SPEED = 3.0
local THROTTLE_ALGO_STOPPED = 0
local THROTTLE_ALGO_STARTED = 1
local throttleState
local MAX_LEAN = 30
local MAX_LEAN_SPEED = 120
local MIN_LEAN = 30
local MAX_SPEED = 400
local MIN_SPEED = 45
local TC = require "TCcruiseControl"
local steerPID


local function brokeBeamsCheck()
    
	for _, b in pairs(v.data.beams) do
		if obj:beamIsBroken(b.cid) and b.breakGroup == "fall" then return true
		end
	end
	return false
	
end





local function logLine(...)
    local args = {...}

  for k,v in ipairs(args) do
      logFile:write(tostring(v))
  
      if k ~= #args then
          logFile:write("+")    
      end
  end
  
  logFile:write("\r\n")
end

local function initLogFile()
	if enableLogToFile == 1 then
 
		if logFile then
			logFile:close()
			logFile = nil
		end

		local logFileName = "datalog"
		local timestamp = os.date("%Y%m%d_%H%M%S")
		local filename = logFileName .. "_" .. timestamp .. ".csv"
		runningTimer = 0

		logFile =  io.open(filename, "w")
		-- Write header:
		-- logLine("time", "throttle", "throttle_input", "engineThrottle", "clutch", "clutch_input", "clutchRatio", "isShifting", "gear", "gearIndex")
		logLine("time", "speed", "steering_input", "throttle", "targetLean", "trueLean", "errorLean", "lastErrorLeanManualSteer", "PID_P", "PID_D", "steeringBike")
		
	end
end

-- BeamNG Controller Functions

local function init_AI()
	electrics.values.AI_rec = 0
	electrics.values.AI_play = 0
	electrics.values.AI_stop = 0
	lastErrorAISteer = 0	
	throttleArray = {}
	steerArray = {}
	posArray = {}	
	clutchArray = {}
	gearIndexArray = {}
	current_AI_index = 0
	recorded_AI_index = 0
	currentGear = 0
	current_AI_state = AI_STATE_STOPPED
end

local function init(jbeamData)
	electrics.values["steeringBike"] = 0
	electrics.values["currentWheelingDistance"] = 0
	lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
	IntegralSumManualSteer = 0 --Integral sum, 
	IntegralSumAISteer = 0
	lastPosition = 0
	timeSinceLastLog = 0
	prev_keyb_steering = 0
	computed_steering = 0
	MIN_SPEED = jbeamData.minSpeed or MIN_SPEED
	AutoThrottle = jbeamData.AutoThrottle or false
	throttleState = THROTTLE_ALGO_STOPPED
	TC.setSpeed(MIN_SPEED)
	initLogFile()
	init_AI()
	
	--function newPIDParallel(kP, 		kI, 		kD, 		minOutput, 	maxOutput, integralInCoef, integralOutCoef, 	minIntegral, 					maxIntegral)
	steerPID = newPIDParallel(0.015, 	0.00001,	0.0005, 	-1.0, 		1.0, 			0.1, 				0.1, 					-0.2, 				0.2)

	
	for k, v in pairs(v.data.activeParts) do
		local partName = k
		if partName == "KeybInput" then
			inputMethod = KEYB_INPUT
			break
		else
			if partName == "WheelInput" then
				inputMethod = WHEEL_INPUT
				break
			end
		end	
	end
		
end

local function reset()
	print("reset!")
	init()
end



local function getSpeedKmh()

return obj:getVelocity():length()*3.6

end


local function limitMAXSpeed()

	local speed = getSpeedKmh()

	if speed > MAX_SPEED then
		electrics.values["throttle"] = 0
	end
end



local function limitMINSpeed(dt)

	local speed = getSpeedKmh()
	
	if input.throttle > 0.0 or input.brake > 0.0 or input.clutch > 0.0 or electrics.values["clutch"] > 0.0 then
		throttleState = THROTTLE_ALGO_STOPPED
		TC.setEnabled(false)
	else
		if throttleState == THROTTLE_ALGO_STARTED then
			electrics.values["throttle"] = TC.computeThrottle(dt)
		else
		if speed > THROTTLE_ALGO_START_SPEED then
				TC.setSpeed(MIN_SPEED)
				throttleState = THROTTLE_ALGO_STARTED
				electrics.values["throttle"] = TC.computeThrottle(dt)
			end
		end
	end
end


	
local function manageAIRecording(dt)
	
	if electrics.values.AI_rec == 1 then
		electrics.values.AI_rec = 0
		electrics.values.AI_stop = 0
		current_AI_state = AI_STATE_RECORDING
		recorded_AI_index = 0
		gui.message("RECORDING")
		print("--------------------RECORDING--------------------")
	end
	if electrics.values.AI_play == 1 then
		electrics.values.AI_stop = 0
		electrics.values.AI_play = 0
		current_AI_state = AI_STATE_PLAYING
		current_AI_index = 0
		currentGear = 0
		gui.message("PLAYING")		
		print("--------------------PLAYING--------------------")
	end
	if electrics.values.AI_stop == 1 then
		electrics.values.AI_stop = 0
		current_AI_state = AI_STATE_STOPPED
		gui.message("STOPPED")		
		print("--------------------STOPPED--------------------")
	end
	


	
	if current_AI_state == AI_STATE_PLAYING then
		if current_AI_index < recorded_AI_index then
		
			if electrics.values["isShifting"] == false then
				electrics.values["throttle"] = throttleArray[current_AI_index]
				electrics.values["clutch"] = clutchArray[current_AI_index]
				electrics.values["clutchRatio"] = 1 - clutchArray[current_AI_index]
			end
			
		--	if current_AI_index > 0 then
		--		electrics.values["steering_input"] = 
		--		compute_steering_input_with_PID(posArray[current_AI_index - 1], posArray[current_AI_index], dt) 
		--	else
		--		electrics.values["steering_input"] = steerArray[current_AI_index]
		--	end
			electrics.values["steering_input"] = steerArray[current_AI_index]

			if gearIndexArray[current_AI_index] ~= 0 then
				if gearIndexArray[current_AI_index] > currentGear then
					controller.mainController.shiftUp()
					currentGear = currentGear + 1
				else
					if gearIndexArray[current_AI_index] < currentGear then
						controller.mainController.shiftDown()
						currentGear = currentGear - 1
					end
				end
			else
				if currentGear == 1 then
					controller.mainController.shiftDown()
					currentGear = 0
				end
			end
			
			current_AI_index = current_AI_index + 1
			if current_AI_index > MAX_AI_ELEMS or current_AI_index > recorded_AI_index then
				current_AI_state = AI_STATE_STOPPED
				gui.message("reached MAX_AI_ELEMS during PLAY")				
			end
		end
	end
	if current_AI_state == AI_STATE_RECORDING then
		throttleArray[recorded_AI_index] = electrics.values["throttle"]
		clutchArray[recorded_AI_index] = electrics.values["clutch"]
		steerArray[recorded_AI_index] = electrics.values["steering_input"]
		posArray[recorded_AI_index] = obj:getPosition()
		gearIndexArray[recorded_AI_index] = electrics.values["gear_M"]
		recorded_AI_index = recorded_AI_index + 1
		if recorded_AI_index > MAX_AI_ELEMS then
			current_AI_state = AI_STATE_STOPPED
			gui.message("reached MAX_AI_ELEMS during REC")
		end
	end
	
	
	
	if enableAILog == 1 then
		timeSinceLastLog = timeSinceLastLog + dt
		runningTimer = runningTimer + dt
		
		if timeSinceLastLog >= minimumLoggingInterval then
			timeSinceLastLog = 0
			
			logLine(
			 tonumber(string.format("%.3f", runningTimer)),
			 electrics.values["throttle"],
			 electrics.values["throttle_input"],
			 electrics.values["engineThrottle"],
			 electrics.values["clutch"],
			 electrics.values["clutch_input"],
			 electrics.values["clutchRatio"],
			 tostring(electrics.values["isShifting"]),
			 tostring(electrics.values["gear"]),
			 tostring(electrics.values["gearIndex"])
			)
			-- print("throttle: " .. electrics.values["throttle"])
			-- print("throttle_input: " .. electrics.values["throttle_input"])
			-- print("engineThrottle: " .. electrics.values["engineThrottle"])
			-- print("clutch: " .. electrics.values["clutch"])
			-- print("clutch_input: " .. electrics.values["clutch_input"])
			-- print("clutchRatio: " .. electrics.values["clutchRatio"])
			-- print("isShifting: " .. tostring(electrics.values["isShifting"]))
			-- print("gear: " .. tostring(electrics.values["gear"]))
			--print("gear_A: " .. tostring(electrics.values["gear_A"]))
			--print("gear_M: " .. tostring(electrics.values["gear_M"]))
			--print("gearIndex: " .. tostring(electrics.values["gearIndex"]))
		end
	end
	
end



local function manageWheeling(dt)

	if electrics.values["wheeling_count"] == 1 then
		if wheelingMeasure == 0 then
			wheelingMeasure = 1 
			gui.message("Start measuring wheeling ...")
		end
	
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->left
		local wheeling = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no x terms
		local trueWheeling = math.deg(math.asin(wheeling))
	
	
		if trueWheeling > 10 then
			local newPosition = obj:getPosition()
			local distance = math.sqrt( (newPosition.x - lastPosition.x) * (newPosition.x - lastPosition.x) + (newPosition.y - lastPosition.y) * (newPosition.y - lastPosition.y))
			local currentWheelingDistance = electrics.values["currentWheelingDistance"] + distance
			electrics.values["currentWheelingDistance"] = currentWheelingDistance
			lastPosition = obj:getPosition()
		else
			lastPosition = obj:getPosition()
		end
	end
	
	if electrics.values["wheeling_count"] == 0 then
		if wheelingMeasure == 1 then
			wheelingMeasure = 0 
			gui.message("Stop measuring wheeling ...")
		end
	end		
		
end


local function computeKeybInputSteering(dt)
	
	local cur_keyb_steering = electrics.values["steering_input"]
	
	if (cur_keyb_steering > computed_steering) then
		computed_steering = computed_steering + KEYB_STEER_INC
		if computed_steering > 1 then
			computed_steering = 1
		end
	else
		if (cur_keyb_steering < computed_steering) then
			computed_steering = computed_steering - KEYB_STEER_INC
			if computed_steering < -1 then
				computed_steering = -1
			end
		end
	end
	
	if math.abs(computed_steering) < KEYB_STEER_INC then
		computed_steering = 0
	end
	
	return computed_steering
end


local function manageSteering(speed, steering, dt)

	local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
	local trueLean = math.deg(math.asin(lean))

	local targetLean = -steering*MAX_LEAN
	if speed > 50 then
		targetLean = -steering*(MIN_LEAN + math.min((speed/MAX_LEAN_SPEED)*(MAX_LEAN - MIN_LEAN), (MAX_LEAN - MIN_LEAN))) --max lean angle is MAX_LEAN degrees
	else
		targetLean = -steering*MIN_LEAN
	end

	return steerPID:get(trueLean, targetLean, dt)
end



local function updateGFX(dt)

	local speed = getSpeedKmh()

	---------------
	if AutoThrottle == true then
		limitMINSpeed(dt)
	end
	---------------

	----------
	limitMAXSpeed()
	----------
	
	----------
	manageAIRecording(dt)
	----------
	
		
	-------------
	manageWheeling(dt)
	-------------



	--------------------
	--manage steering aid
	if 	inputMethod == KEYB_INPUT then
		-- Keyboard/Controller steering
		local steering = computeKeybInputSteering(dt) 
		local steeringOutput = manageSteering(speed, steering, dt)

		electrics.values["steeringBikeKeyb"] = steeringOutput

	else
		-- Steering Wheel steering
		local steering = electrics.values["steering_input"]
		local steeringOutput = manageSteering(speed, steering, dt)

		electrics.values["steeringBikeWheel"] = steeringOutput
	end

	-------------	
	--Kickstand
	if speed > 15 or electrics.values.kickstand == 1 then 
		electrics.values["kickstand_retract"] = 1 else
		electrics.values["kickstand_retract"] = 0
	end
	
	--------------
	--manage throttle if rider fell
	if brokeBeamsCheck() then
		electrics.values["throttle"] = 0
		electrics.values["steeringBikeKeyb"] = 0
		electrics.values["steeringBikeWheel"] = 0
	end 
	--------------
	--Frame holder
	-- for _, beam in pairs(v.data.beams) do if beam.breakgroup == "frame_support_holder" then dump(beam.cid) end end
	if speed > 10 or electrics.values.frame_holder_retract == 1 then 
		electrics.values["frm_hld_retract"] = 1 
	else
		electrics.values["frm_hld_retract"] = 0 
	end
	--------------


end




M.init      = init
M.updateGFX = updateGFX

return M