local M = {}
local device = nil
local cabinFilterCoef = 1
local cabinFilterChanged = false
local doorFL = nil
local doorFR = nil
local doorRL = nil
local doorRR = nil
local hood = nil
local trunk = nil
local doorFLLength = 0
local doorFRLength = 0
local doorRLLength = 0
local doorRRLength = 0
local trunkLength = 0
local hoodLength = 0
local isDoorAjar = 0
local doorStateChanged = 0
local doorMissing = false

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

function round(num, numDecimalPlaces)
  local mult = 10^(numDecimalPlaces or 0)
  return math.floor(num * mult + 0.5) / mult
end

--This File contains the Vertex's gauge cluster starting sequence, the key twisting logic and the DRL logic, logic for moving the automatic shifter as well as a bit of stuff for the "door open" gauge light
local function onInit()
    device = powertrain.getDevice("mainEngine") or powertrain.getDevice("frontMotor")
    electrics.values["isDoorAjar"] = 0
	
	doorFL = nil
	doorFR = nil
	doorRL = nil
	doorRR = nil
	hood = nil
	trunk = nil
	doorFLLength = 0
	doorFRLength = 0
    doorRLLength = 0
	doorRRLength = 0
	trunkLength = 0
	hoodLength = 0
	isDoorAjar = 0

    for _, b in pairs (v.data.beams) do
		if b.name == "doorLatch_FL" then doorFL = b.cid end
		if b.name == "doorLatch_FR" then doorFR = b.cid end
		if b.name == "doorLatch_RL" then doorRL = b.cid end
		if b.name == "doorLatch_RR" then doorRR = b.cid end
		if b.name == "trunkLatch" then trunk = b.cid end
		if b.name == "hoodLatch" then hood = b.cid end
    end
	
	if v.data.sounds then
		cabinFilterCoef = v.data.sounds.cabinFilterCoef == nil and 1 or v.data.sounds.cabinFilterCoef
		print(cabinFilterCoef)
	end
end

local function onReset()
    electrics.values["isDoorAjar"] = 0
	electrics.values["domelight"] = 0
	electrics.values["key"] = 0
	isDoorAjar = 0
	doorStateChanged = 0
	if cabinFilterChanged then
		obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", cabinFilterCoef))
		cabinFilterChanged = false
	end
end

local function updateGFX(dt) 
  --Door open detection logic as well as domelight and cabin filter logic
  --set to 1 when doesnt exist
    if doorFL then
		doorFLLength = obj:getBeamLength(doorFL)
	else
		doorFLLength = 1
		doorMissing = true
	end
    if doorFR then
		doorFRLength = obj:getBeamLength(doorFR)
	else
		doorFRLength = 1
		doorMissing = true
	end
    if doorRL then
		doorRLLength = obj:getBeamLength(doorRL)
	else
		doorRLLength = 1
		doorMissing = true
	end
    if doorRR then
		doorRRLength = obj:getBeamLength(doorRR)
	else
		doorRRLength = 1
		doorMissing = true
	end
    if trunk then
		trunkLength = obj:getBeamLength(trunk)
	else
		trunkLength = 1
	end
    if hood then
		hoodLength = obj:getBeamLength(hood)
	else
		hoodLength = 1
	end

	if doorFRLength >= 0.01 or doorFLLength >= 0.01 or doorRRLength >= 0.01 or doorRLLength >= 0.01 then
		isDoorAjar = 1
		if doorStateChanged ~= isDoorAjar then
			doorStateChanged = isDoorAjar
			if electrics.values["ignitionLevel"] >= 0 and not doorMissing then electrics.values["domelight"] = 1 end --only change it when ignition is on and no door is missing (otherwise kinda annoying)
			cabinFilterChanged = true
			obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))
		end
	else
		isDoorAjar = 0
		if doorStateChanged ~= isDoorAjar then
			doorStateChanged = isDoorAjar
			electrics.values["domelight"] = 0
			cabinFilterChanged = false
		obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", cabinFilterCoef))
		end
	end
  
    if isDoorAjar == 1 or trunkLength >= 0.01 or hoodLength < -1 then
		if electrics.values["ignitionLevel"] > 1 then electrics.values["isDoorAjar"] = 1 end 
	else
		electrics.values["isDoorAjar"] = 0
	end

    if trunkLength >= 0.01 then
		electrics.values["tailgate"] = 1
	else
		electrics.values["tailgate"] = 0
	end
  
    if electrics.values["ignitionLevel"] <= 1 then
		electrics.values["isDoorAjar"] = 0
	end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M