local M = {}

local chimenode = 350
local function init()

	for v, node in pairs (v.data.nodes) do	--for finding out the node ID
		if node.name == "int3" then	
			chimenode = v
		end
	end
	
	if chimenode ~= nil then
	    chime = obj:createSFXSource("art/sound/chimes/gm_b_body_1991_chime_start.ogg", 'AudioDefaultLoop3D', '', chimenode)
	    obj:stopSFX(chime)
	    obj:setVolume(chime, 0.0)
	end

end

local timer = 0 -- initialize the timer variable

local function updateGFX(dt)

   if electrics.values.ignitionLevel == 2 then
      if timer < 5 then
         timer = timer + dt -- increment the timer variable by delta time
      else
		if chimenode ~= nil then
			obj:stopSFX(chime)
			obj:setVolume(chime, 0.0)
		end
      end
   else
      timer = 0 -- reset the timer when ignition level is not 2
   end

   if electrics.values.rpm >= 0 and electrics.values.rpm <= 500 then
      if electrics.values.ignitionLevel >= 0 and electrics.values.ignitionLevel <= 1 then
         electrics.values.capr91systemscheck = 0
		if chimenode ~= nil then
			obj:stopSFX(chime)
			obj:setVolume(chime, 0.0)
		end
      else
		if chimenode ~= nil then
	    obj:playSFX(chime)
	    obj:setVolume(chime, 0.25)
	end
      end
   else
   end
end

local function onReset()
	if chimenode ~= nil then
		obj:stopSFX(chime)
		obj:setVolume(chime, 0.0)
	end
 end

M.onInit = init
M.updateGFX = updateGFX
M.onReset    = onReset

return M