local M = {}
local device = nil
local doorFL = nil
local doorFR = nil
local doorRL = nil
local doorRR = nil
local hood = nil
local trunk = nil
local doorFLLength = 0
local doorFRLength = 0
local doorRLLength = 0
local doorRRLength = 0
local trunkLength = 0
local hoodLength = 0
local isDoorAjarAcc = 0
local doorStateChanged = 0
local doorMissing = false

local doorchimenode = 350

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

function round(num, numDecimalPlaces)
  local mult = 10^(numDecimalPlaces or 0)
  return math.floor(num * mult + 0.5) / mult
end

--This File contains the Vertex's gauge cluster starting sequence, the key twisting logic and the DRL logic, logic for moving the automatic shifter as well as a bit of stuff for the "door open" gauge light
local function onInit()
    device = powertrain.getDevice("mainEngine") or powertrain.getDevice("frontMotor")
    electrics.values["isDoorAjarAcc"] = 0
	
	doorFL = nil
	doorFR = nil
	doorRL = nil
	doorRR = nil
	hood = nil
	trunk = nil
	doorFLLength = 0
	doorFRLength = 0
    doorRLLength = 0
	doorRRLength = 0
	trunkLength = 0
	hoodLength = 0
	isDoorAjarAcc = 0

    for _, b in pairs (v.data.beams) do
		if b.name == "doorLatch_FL" then doorFL = b.cid end
		if b.name == "doorLatch_FR" then doorFR = b.cid end
		if b.name == "doorLatch_RL" then doorRL = b.cid end
		if b.name == "doorLatch_RR" then doorRR = b.cid end
		if b.name == "trunkLatch" then trunk = b.cid end
		if b.name == "hoodLatch" then hood = b.cid end
    end

	for v, node in pairs (v.data.nodes) do	--for finding out the node ID
		if node.name == "int3" then	
			doorchimenode = v
		end
	end
	
	if doorchimenode ~= nil then
	    doorchime = obj:createSFXSource("art/sound/chimes/gm_b_body_1991_chime_door.ogg", 'AudioDefaultLoop3D', '', doorchimenode)
	    obj:stopSFX(doorchime)
	    obj:setVolume(doorchime, 0.0)
	end
end

local function onReset()
    electrics.values["isDoorAjarAcc"] = 0
	electrics.values["key"] = 0
	isDoorAjarAcc = 0
	doorStateChanged = 0
	if doorchimenode ~= nil then
		obj:stopSFX(doorchime)
		obj:setVolume(doorchime, 0.0)
	end
end

local function updateGFX(dt) 
  --Door open detection logic as well as domelight and cabin filter logic
  --set to 1 when doesnt exist
    if doorFL then
		doorFLLength = obj:getBeamLength(doorFL)
	else
		doorFLLength = 1
		doorMissing = true
	end
    if doorFR then
		doorFRLength = obj:getBeamLength(doorFR)
	else
		doorFRLength = 1
		doorMissing = true
	end
    if doorRL then
		doorRLLength = obj:getBeamLength(doorRL)
	else
		doorRLLength = 1
		doorMissing = true
	end
    if doorRR then
		doorRRLength = obj:getBeamLength(doorRR)
	else
		doorRRLength = 1
		doorMissing = true
	end
    if trunk then
		trunkLength = obj:getBeamLength(trunk)
	else
		trunkLength = 1
	end
    if hood then
		hoodLength = obj:getBeamLength(hood)
	else
		hoodLength = 1
	end

	if doorFRLength >= 0.01 or doorFLLength >= 0.01 or doorRRLength >= 0.01 or doorRLLength >= 0.01 and electrics.values["ignitionLevel"] == 1 then
		isDoorAjarAcc = 1
		if doorStateChanged ~= isDoorAjarAcc then
			doorStateChanged = isDoorAjarAcc
			if not doorMissing then 
				if doorchimenode ~= nil then
					obj:playSFX(doorchime)
					obj:setVolume(doorchime, 0.25)
				end
			end --only change it when ignition is on and no door is missing (otherwise kinda annoying)
		end
	else
		isDoorAjarAcc = 0
		if doorStateChanged ~= isDoorAjarAcc then
			doorStateChanged = isDoorAjarAcc
			if doorchimenode ~= nil then
				obj:stopSFX(doorchime)
				obj:setVolume(doorchime, 0.0)
			end
		end
	end

	if doorFRLength >= 0.01 or doorFLLength >= 0.01 or doorRRLength >= 0.01 or doorRLLength >= 0.01 and electrics.values["ignitionLevel"] > 1 then
		isDoorAjarAcc = 1
		if doorStateChanged ~= isDoorAjarAcc then
			doorStateChanged = isDoorAjarAcc
			if not doorMissing then 
				if doorchimenode ~= nil then
					obj:stopSFX(doorchime)
					obj:setVolume(doorchime, 0.0)
				end
			end --only change it when ignition is on and no door is missing (otherwise kinda annoying)
		end
	else
		isDoorAjarAcc = 0
		if doorStateChanged ~= isDoorAjarAcc then
			doorStateChanged = isDoorAjarAcc
			if doorchimenode ~= nil then
				obj:stopSFX(doorchime)
				obj:setVolume(doorchime, 0.0)
			end
		end
	end

	if electrics.values["ignitionLevel"] == 1 and isDoorAjarAcc == 1 then
		if not doorMissing then 
			if doorchimenode ~= nil then
				obj:playSFX(doorchime)
				obj:setVolume(doorchime, 0.25)
			end
		end --only change it when ignition is on and no door is missing (otherwise kinda annoying)
	end
  
    if isDoorAjarAcc == 1 or trunkLength >= 0.01 or hoodLength < -1 then
		if electrics.values["ignitionLevel"] > 1 then electrics.values["isDoorAjarAcc"] = 1 end 
	else
		electrics.values["isDoorAjarAcc"] = 0
	end

if electrics.values["ignitionLevel"] > 1 then
			if doorchimenode ~= nil then
				obj:stopSFX(doorchime)
				obj:setVolume(doorchime, 0.0)
			end
	end
if electrics.values["ignitionLevel"]  < 1 then
			if doorchimenode ~= nil then
				obj:stopSFX(doorchime)
				obj:setVolume(doorchime, 0.0)
			end
	end

    if trunkLength >= 0.01 then
		electrics.values["tailgateAcc"] = 1
	else
		electrics.values["tailgateAcc"] = 0
	end
  
    if electrics.values["ignitionLevel"] <= 1 then
		electrics.values["isDoorAjarAcc"] = 0
	end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M