angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var gauge = { gears: {} };
    var tacho = {  };
    var infoDisplay = {};
    var roots = {};
    var electrics = {lights:{} };
    var gagues = {fuel:{},temp:{}};


    var speedoInitialised = true;
    var currentGear = '';

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 2.23694;


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
        console.log("onSVGLoaded");
      svg = $element[0].children[0].children[0];


      gauge.speedValue = hu('#speedo_txt', svg);

      roots.speedo_bar = hu('#speedo_bar', svg);


      electrics.root = hu('#electrics', svg);

      ready = true;
    }

    function updateSpeedDisplays(data) {
      let speed = data.electrics.wheelspeed * unitspeedConv
      gauge.speedValue.text((speed ).toFixed(0));

      let children = roots.speedo_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {//lucky that the order of elements are ok
        children[i].style.display = (speed > i*2.72)?"inline":"none";
      }

    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);

    }

    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {

      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }

    }


    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);

        // Update Speed displays
        updateSpeedDisplays(data);
      }
    }
    //ready = true;
  });