-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    
	electrics.values['wheellift'] = 0
    electrics.values['wheellift_input'] = 0
	electrics.values['underlift_updown'] = 0
    electrics.values['underlift_updown_input'] = 0
	electrics.values['underlift_ext'] = 0
    electrics.values['underlift_ext_input'] = 0
	
	
   
	
  
end

local function updateGFX(dt)


    
	electrics.values['wheellift'] = math.min(1, math.max(-0, (electrics.values['wheellift'] + electrics.values['wheellift_input'] * dt * 0.4)))
	electrics.values['underlift_updown'] = math.min(1, math.max(-0, (electrics.values['underlift_updown'] + electrics.values['underlift_updown_input'] * dt * 0.3)))
	electrics.values['underlift_ext'] = math.min(1, math.max(-0, (electrics.values['underlift_ext'] + electrics.values['underlift_ext_input'] * dt * 0.2)))
	
	
	
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
