-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local gearbox = nil
local electricsName = nil -- TODO: implement
local bump = false -- if bump logic should run on update
local bumpTime = 0.02 -- how long to disengage transbrake
local lastDeltaTime = 0 -- time passed since disengagement

local function init(jbeamData)
  local gearboxName = jbeamData.gearboxName or "gearbox"
  electricsName = jbeamData.electricsName or "transbrake"
  gearbox = powertrain.getDevice(gearboxName)
  bumpTime = jbeamData.time or 0.02 -- specify disengagement time in jbeam: ["bumpbox", {"time": "$bumpTime"}]
end

-- taken from transbrake.lua
local function setTransbrake(value)
  if gearbox then
    gearbox:setLock(value)
  end
end

local function updateGFX(dt)
  if bump then
    setTransbrake(false)
    --electrics.values.brake = 0.9
    lastDeltaTime = lastDeltaTime + dt
    if lastDeltaTime > bumpTime then
      bump = false
      lastDeltaTime = 0
      setTransbrake(true)
      --electrics.values.brake = 0
    end
  end
end

local function bumpForward()
  if gearbox.lockCoef == 0 then -- only bump if transbrake is already active
    bump = true
  end
end

-- public interface
M.init = init
M.updateGFX = updateGFX
M.bumpForward = bumpForward

return M
