-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = "supercharger"

local supercharger = nil

local function updateGFX(dt)
	electrics.values.superchargerBoost = supercharger.blowerPressure
end

local function init()
	electrics.values.superchargerBoost = 0
	supercharger = powertrain.getDevice("supercharger").supercharger or nil
	if not supercharger then
		M.updateGFX = nop
	end
end

M.init = init
M.updateGFX = updateGFX

return M
