--Thanks to TrackpadUser for the base code and aljowen for the smooth brake glow concept :3
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local exhaust_glow = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS
local exhaust_temp = 0

local function init(jbeamData)
	exhaust_glow = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 256
	local height = jbeamData.textureHeight or 256

    exhaust_temp = 0
	
	exhaust_temp = powertrain.getDevice("mainEngine").thermals.exhaustTemperature

    htmlTexture.create(exhaust_glow, htmlPath, width, height, updateFPS, "automatic")
	htmlTexture.call(exhaust_glow, "init", exhaust_temp)
end

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then
  
	if powertrain.getDevice("mainEngine").thermals then
		exhaust_temp = powertrain.getDevice("mainEngine").thermals.exhaustTemperature or 0
	end
	exhaust_temp = powertrain.getDevice("mainEngine").thermals.exhaustTemperature

    htmlTexture.call(exhaust_glow, "update", exhaust_temp)
    updateTimer = 0
  end
end

M.init = init
M.updateGFX = updateGFX

return M
