-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local motors = {}
local powerDisplay = 0
local motorCount = 0
local isMoving = nil
local powerDisplaySmoother = newExponentialSmoothingT(15) --newLinearSmoothing(200)
local pause = false
local timer = 0

local function updateGFX()
    powerDisplay = 0
    motorCount = 0
    isMoving = electrics.values.wheelspeed > 0.1

    if electrics.values.regenThrottlePedal then
        for _, motor in ipairs(motors) do
            local throttle = math.max(motor.throttle or 0, 0)
            powerDisplay = powerDisplay + (throttle or 0) * 1.55 -- this value is dependant on the gauges

            local regenThrottle = (motor.regenThrottle or 0) / (electrics.values.fullRegenAmount)
            powerDisplay = powerDisplay - regenThrottle * 0.8 -- this value is dependant on the gauges
            motorCount = motorCount + 1
        end

        powerDisplay = (motorCount > 0 and (powerDisplay / motorCount * (isMoving and 1 or 0)) or 0)

        electrics.values.powerDisplay = powerDisplaySmoother:get(powerDisplay * 3000) + 2400 -- this value is dependant on the gauges
    else
        for _, motor in ipairs(motors) do
            powerDisplay = powerDisplay + (motor.throttle or 0) * 1.55 -- this value is dependant on the gauges
            powerDisplay = powerDisplay - (motor.regenThrottle or 0) * 0.8 -- this value is dependant on the gauges
            motorCount = motorCount + 1
        end

        powerDisplay = (motorCount > 0 and (powerDisplay / motorCount * (isMoving and 1 or 0)) or 0)
        electrics.values.powerDisplay = powerDisplaySmoother:get(powerDisplay * 3000) + 2400 -- this value is dependant on the gauges
    end

    if pause then
        print("mod not downloaded from beamng.com")
        guihooks.message("MOD IS NOT DOWNLOADED FROM BEAMNG.COM, preventing usage. Please use the official BeamNG Website.", 9999, "ebngtunerbydseal.disallowUse")
        obj:queueGameEngineLua('bullettime.pause(true)')

        timer = timer + 1
        if timer >= 4 then
            --obj:queueGameEngineLua('shutdown(1)')
        end
    end
end

local function init(jbeamdata)
    powerDisplay = 0
    electrics.values.powerDisplay = 0
    motors = powertrain.getDevicesByType("electricMotor")

    pause = not FS:fileExists("mod_info/MKBUF91OJ/info.json")
end

M.init = init
M.updateGFX = updateGFX

return M