--- Custom Beamers
local M = {}
local cornerlight_active = { left = false, right = false }
local off_timer = { left = 0, right = 0 }
local on_timer = { left = 0, right = 0 }

local function updateCornerlight(side, dt)
    if electrics.values["cornerlight_" .. side] == 1 then
        off_timer[side] = 0
        cornerlight_active[side] = true
        on_timer[side] = on_timer[side] + dt
        if on_timer[side] >= 0 then
            electrics.values["cornerlight_" .. side] = 1
        end
    else
        on_timer[side] = 0
        if cornerlight_active[side] then
            off_timer[side] = off_timer[side] + dt
            if off_timer[side] >= 0.0 then
                electrics.values["cornerlight_" .. side] = 0
                cornerlight_active[side] = false
                off_timer[side] = 0
            end
        else
            electrics.values["cornerlight_" .. side] = 0
        end
    end
end

local function smoothlights(dt)
    updateCornerlight("left", dt)
    updateCornerlight("right", dt)
end

local function updateGFX(dt)
    local ignition = electrics.values.ignitionLevel
    local wheelspeed = electrics.values.wheelspeed
    local steering = electrics.values.steering

    if ignition <= 1 or wheelspeed > 40 / 3.6 then
        electrics.values.cornerlight_left = 0
        electrics.values.cornerlight_right = 0
    elseif steering < -75 or (wheelspeed < 30 / 3.6 == 0) then
        electrics.values.cornerlight_left = 0
        electrics.values.cornerlight_right = 1
    elseif steering > 75 or (wheelspeed < 30 / 3.6 == 0) then
        electrics.values.cornerlight_left = 1
        electrics.values.cornerlight_right = 0
    else
        electrics.values.cornerlight_left = 0
        electrics.values.cornerlight_right = 0
    end

    smoothlights(dt)
end

-- public interface
M.updateGFX = updateGFX
return M

