angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $element, $window) {

  const rpmMax = 10000;
  const speedMax = 330;
  const tempMax = 130;
  const fuelMax = 100;
  const oilTempMax = 150;

  let units = { uiUnitLength: "metric", uiUnitTemperature: "c" };
  $scope.data = {};
  
  
 

  let lastRpm = 0, targetRpm = 0;
  let lastSpeed = 0, targetSpeed = 0;
  let lastTemp = 0, targetTemp = 0;
  let lastFuel = 0, targetFuel = 0;
  let lastOil = 0, targetOil = 0;
  let lastFuelCons = 0, targetFuelCons = 0;
    var speedoDisplay = { gears: {}, gearsBOX: {} };
    var navDisplay = {};
	var text = {  };
    var infoDisplay = {};
	var gMeterPage = {};
	var DatePage = {};
	var TempPage = {};
	var TirePresPage = {};
	var InfoPage = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{} };
    var gForcesVisible = false;
	




function animateNeedles() {
  lastRpm += (targetRpm - lastRpm) * 0.2;
  lastSpeed += (targetSpeed - lastSpeed) * 0.2;
  lastTemp += (targetTemp - lastTemp) * 0.2;
  lastFuel += (targetFuel - lastFuel) * 0.2;
  lastOil += (targetOil - lastOil) * 0.2;

  const rpmNeedle = document.querySelector('.needle-rpm');
  if (rpmNeedle) {
    const angle = -88.5 + (lastRpm / rpmMax) * 303;
    rpmNeedle.style.transform = `rotate(${angle}deg)`;
  }

  const speedNeedle = document.querySelector('.needle-speed');
  if (speedNeedle) {
    const limitedSpeed = Math.min(lastSpeed, 300);
    const angle = -142.8 + (limitedSpeed / speedMax) * 254.4;
    speedNeedle.style.transform = `rotate(${angle}deg)`;
  }

const tempNeedle = document.querySelector('.needle-temp');
if (tempNeedle) {
  const minTemp = 30;
  const maxTemp = 155;
  const minAngle = 153.8; // начальное положение стрелки при 60°C
  const maxAngle = 57.8;  // конечное положение стрелки при 130°C

  const clampedTemp = Math.max(minTemp, Math.min(lastTemp, maxTemp));
  const angle = minAngle + ((clampedTemp - minTemp) / (maxTemp - minTemp)) * (maxAngle - minAngle);

  tempNeedle.style.transform = `rotate(${angle}deg)`;
}

  const fuelNeedle = document.querySelector('.needle-fuel');
  if (fuelNeedle) {
    const angle = -151 + (lastFuel / fuelMax) * 97;
    fuelNeedle.style.transform = `rotate(${angle}deg)`;
  }

  const oilNeedle = document.querySelector('.needle-oil');
  if (oilNeedle) {
    const angle = -150 + (lastOil / oilTempMax) * 130;
    oilNeedle.style.transform = `rotate(${angle}deg)`;
  }

  requestAnimationFrame(animateNeedles);
}

  animateNeedles();

  $window.setup = (setupData) => {
    for (let dk in setupData) {
      if (typeof dk === "string" && dk.startsWith("uiUnit")) {
        units[dk] = setupData[dk];
      }
    }
    $scope.data.speedUnit = (units.uiUnitLength === "metric") ? "km/h" : "mph";
  };




  $window.updateData = (data) => {
	  
    $scope.$evalAsync(() => {
		
  
  
      const rpm = data.electrics.rpm || 0;
      const speed = (data.electrics.wheelspeed || 0) * 3.6;
      const fuel = data.electrics.fuel || 0;
      const coolant = data.electrics.watertemp || 0;
      const odometer = data.electrics.odometer || 0;
      const oiltemp = data.electrics.oiltemp || 0;
      const currentFuelConsumption = data.customModules?.combustionEngineData?.currentFuelConsumption || 0;


      targetRpm = rpm;
      targetSpeed = speed;
      targetFuel = fuel * 100;
      targetTemp = coolant;
      targetOil = oiltemp;
      targetFuelCons = currentFuelConsumption;

	   
      $scope.data.engineRpm = Math.round(rpm);
      $scope.data.fuel = Math.round(fuel * 100);

      $scope.data.odo = (units.uiUnitLength === "metric")
        ? (odometer / 1000).toFixed(1).padStart(6, "0")
        : (odometer * 0.0006215).toFixed(1).padStart(6, "0");

      $scope.data.odo1 = (units.uiUnitLength === "metric")
        ? (odometer / 1000).toFixed(0).padStart(5, "0")
        : (odometer * 0.0006215).toFixed(0).padStart(5, "0");


      $scope.data.fuelConsumption = (units.uiUnitLength === "metric")
        ? currentFuelConsumption.toFixed(1) + " l/100km"
        : (235.2 / currentFuelConsumption).toFixed(1) + " mpg";


      let temperatureEnv = data.customModules?.environmentData?.temperatureEnv;
      if (units.uiUnitTemperature === 'c') {
        $scope.data.temp = (temperatureEnv > 99.9 || temperatureEnv < -99.9)
          ? "---°C"
          : (temperatureEnv >= 0 ? "+" : "") + temperatureEnv.toFixed(1) + "°C";
      } else {
        const fahrenheit = (temperatureEnv * 9 / 5) + 32;
        $scope.data.temp = (fahrenheit > 99.9 || fahrenheit < -99.9)
          ? "---°F"
          : (fahrenheit >= 0 ? "+" : "") + fahrenheit.toFixed(1) + " °F";
      }


      let rawGear = data.electrics.gear;
      if (rawGear === -1) {
        $scope.data.gear = "R";
      } else if (rawGear === 0) {
        $scope.data.gear = "N";
      } else if (typeof rawGear === "string") {
        $scope.data.gear = rawGear.replace(/^S|^M/, "");
      } else {
        $scope.data.gear = rawGear;
      }


      const fuelUsed = data.engine?.fuelUsed || 0;
      const distanceKm = odometer / 1000;
      let avgConsumption = 15;
      if (distanceKm > 0.5 && fuelUsed > 0.01) {
        avgConsumption = (fuelUsed / distanceKm) * 100;
      }
      const fuelCapacity = data.engine?.fuelCapacity || 75;
      const fuelLiters = fuel * fuelCapacity;
      let range = fuelLiters / avgConsumption * 100;
      $scope.data.range = Math.round(range);






  });
  };
});
