local M = {}

--Wheeling measure
local lastPosition = 0
local wheelingMeasure = 0

--Pedaling
local autoPedal = 0
local pedalingEnabled = 1

local rotorInversionDistance_R = 0.0
local rotorInversionDistance_L = 0.0

local PISTON_EXT = 1

local pistonPos_L_cid = 0
local pistonPos_R_cid = 0

local pistonBase_L_cid = 0
local pistonBase_R_cid = 0

local rotorInversionBase_L_cid = 0
local rotorInversionBase_R_cid = 0

local rotorMoving_R_cid = 0
local rotorMoving_L_cid = 0


local ringNode_cid = 0
local ringPresent = false
local sound_file = "art/ring/ring.wav"


local MAX_LEAN = 35
local MAX_SPEED = 300
local MAX_WHEELING = 35
local leanPID

local wheeliePID

local riderFallen = false



local function brokeBeamsCheck()
    
	for _, b in pairs(v.data.beams) do
		if obj:beamIsBroken(b.cid) and b.breakGroup == "fall" then return true
		end
	end
	return false
	
end


local function manageRing(dt)

	if 	true == ringPresent and electrics.values["ring_bell"] == 1 then	  
		electrics.values["ring_bell"] = 0	
		obj:playSFXOnceStaticCT("ringBell", ringNode_cid, 9, 1, 0, 0)
	end
end


local function getSpeedKmh()
	return wheels.wheels[0].wheelSpeed*3.6
end

local function manageAutoWheeling(dt)

	local pitchTarget = MAX_WHEELING
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->right
	local pitch = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no z terms
	local truePitch = math.deg(math.asin(pitch))
	
	electrics.values["wheelerForce"] = wheeliePID:get(truePitch, pitchTarget, dt)

end

local function manageWheeling(trueLean, dt)

	if math.abs(trueLean) < (MAX_LEAN + 10) then 
		if electrics.values["wheelie"] == 1 then
			electrics.values["wheelerForce"] = 0.3
			electrics.values["stopperForce"] = 0
		else
			if electrics.values["toggle_wheelie"] == 1 then
				manageAutoWheeling(dt)
			else
				electrics.values["wheelerForce"] = 0
				if electrics.values["stoppie"] == 1 then
					electrics.values["stopperForce"] = 1
				else
					electrics.values["stopperForce"] = 0
				end
			end
		end
	else
		electrics.values["wheelerForce"] = 0
		electrics.values["stopperForce"] = 0
	end
	
end	

local function limitMAXSpeed(speed)
	if speed > MAX_SPEED then
		electrics.values["throttle"] = 0
	end
end



local function manageWheelingMeasure(dt)

	if electrics.values["wheeling_count"] == 1 then
		if wheelingMeasure == 0 then
			wheelingMeasure = 1 
			gui.message("Start measuring wheeling ...")
		end
	
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->left
		local wheeling = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no x terms
		local trueWheeling = math.deg(math.asin(wheeling))
	
	
		if trueWheeling > 10 then
			local newPosition = obj:getPosition()
			local distance = math.sqrt( (newPosition.x - lastPosition.x) * (newPosition.x - lastPosition.x) + (newPosition.y - lastPosition.y) * (newPosition.y - lastPosition.y))
			local currentWheelingDistance = electrics.values["currentWheelingDistance"] + distance
			electrics.values["currentWheelingDistance"] = currentWheelingDistance
			lastPosition = obj:getPosition()
		else
			lastPosition = obj:getPosition()
		end
	end
	
	if electrics.values["wheeling_count"] == 0 then
		if wheelingMeasure == 1 then
			wheelingMeasure = 0 
			gui.message("Stop measuring wheeling ...")
		end
	end		
		
end

local function computeTrueLean()

	local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
	local trueLean = math.deg(math.asin(lean))
	
	return trueLean

end


local function manageDownPressure(trueLean, speed)

	if 	math.abs(trueLean) < (MAX_LEAN + 10) and 
		(wheels.wheels[1].contactMaterialID1>0 or wheels.wheels[0].contactMaterialID1>0) and
		electrics.values["wheelie"] == 0 and
		electrics.values["toggle_wheelie"] == 0
		then
		electrics.values["downPressure"] = 1
	else
		electrics.values["downPressure"] = 0
	end
	
	--[[
	dump(string.format("dp: %0.3f", 
		electrics.values["downPressure"]))
	]]--
	
end

local function manageLeanLowSpeed(trueLean, speed, dt)

	local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
	local targetLean = 0
	local steering = 0
	local balanceForce = 0
	local Kp = 0
	local Ki = 0
	local Kd = 0
	
	
	if math.abs(speed) < 1 then speed = 0 end
	
	--reduce steering input in function of speed
	if (speed >= 0 and speed < 50) or speed < 0 then
		steering = -electrics.values["steering_input"]
	else
		steering = -electrics.values["steering_input"]*(50/speed)
	end	
	
	electrics.values["steering_adjusted"] = -steering
	
	
	if math.abs(trueLean) < MAX_LEAN + 10 and wheels.wheels[0].contactMaterialID1>0 then
		
		if speed == 0 and electrics.values["kickstand"] == 0 then
			targetLean = 10
		else
			targetLean = (math.min(1, speed/20))*(steering)*MAX_LEAN*(electrics.values.reverse == 1 and -1 or 1)
		end

		Kp = 0.008*math.max(0.3, (1 - (speed/140)))
		

		--local Ki = 0.5*(steering ~=0 and 1 or 0.1/0.5) --math.min(1, speed/100)
		--local Ki = speed > 50 and (0.4*math.min(1, math.max(0.1/0.4, speed/130))*(steering ~=0 and 1 or 0.1/(0.4*math.min(1, math.max(0.1/0.4, speed/130))))) or 0.1
		--local Ki = 0.5*math.min(1, math.abs(targetLean-trueLean)/10)

		
		if speed == 0 then
			Ki = 0.01
			Kd = 0.0020*math.max(0.4, (1 - (speed/150)))
		else
			if (speed > 0 and speed < 50) or speed < 0 then
				Ki = 0.2*math.min(1, speed/50)*(steering ~=0 and 1 or 0.05/(0.2*math.min(1, speed/50)))
				Kd = 0.0020*math.max(0.4, (1 - (speed/150)))
			else if speed >= 50 and speed < 100 then
					Ki = 0.5*math.min(1, speed/100)*(steering ~=0 and 1 or 0.1/(0.5*math.min(1, speed/100)))
					Kd = 0.0050*math.max(0.4, (1 - (speed/150)))
				else if speed > 100 and speed < 200 then
						Ki = 0.6*(math.abs(steering) >=0 and math.max(0.1/0.6, math.abs(steering)) or 0.1/0.6)
						Kd = 0.0050*math.max(0.4, (1 - (speed/200)))
					else -- >=200
						Ki = 0.5*(math.abs(steering) >=0 and math.max(0.1/0.5, math.abs(steering)) or 0.1/0.5)
						Kd = 0.0030
						Kp = 0.005
					end
				end
			end
		end
				
		--local Kd = 0.0015*math.max(1, (2.1)*speed/90)
		
		
	  --leanPID:setConfig(kP, 	kI, 	kD, 	minOutput, 	maxOutput, 		integralInCoef, 	integralOutCoef, 		minIntegral, 		maxIntegral)
		leanPID:setConfig(Kp, 	Ki,		Kd, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
		
		balanceForce = leanPID:get(trueLean, targetLean, dt)*(steering ~=0 and math.max(1, speed/100) or 1)
		
		electrics.values["balanceForceRL"] = balanceForce < 0 and -balanceForce or 0
		electrics.values["balanceForceLR"] = balanceForce > 0 and balanceForce or 0
		
		
		--[[
		dump(string.format("sp: %0.3f - TrL: %0.3f - TgL: %0.3f - bF: %0.3f", 
			speed,
			trueLean, 
			targetLean, 
			balanceForce))
		]]--

	else

		electrics.values["balanceForceRL"] =  0
		electrics.values["balanceForceLR"] =  0

	end
	
	--dump(string.format("sp:%0.4f - kp: %0.4f - ki: %0.4f - kd: %0.4f - bF: %0.4f - st: %0.4f", speed, Kp, Ki, Kd, balanceForce, electrics.values["steering_adjusted"]))
end

local function updateGFX(dt)


	if riderFallen == false and false == brokeBeamsCheck() then
	
		local speed = M.getSpeedKmh()
	
		local trueLean = M.computeTrueLean()
		
		----------
		M.limitMAXSpeed(speed)
		----------
		
		-------------
		M.manageWheelingMeasure(dt)
		-------------
		
		-------------
		M.manageWheeling(trueLean, dt)
		-------------
			
		--------------
		M.manageLeanLowSpeed(trueLean, speed, dt)
		--------------
		
		--------------
		M.manageDownPressure(trueLean, speed)
		--------------
	
		local throttle = electrics.values["throttle"]

		local rotorInversionBase_L_pos = vec3(obj:getNodePosition(rotorInversionBase_L_cid))
		local rotorInversionBase_R_pos = vec3(obj:getNodePosition(rotorInversionBase_R_cid))
		
		local rotorMoving_L_pos = vec3(obj:getNodePosition(rotorMoving_L_cid))
		local rotorMoving_R_pos = vec3(obj:getNodePosition(rotorMoving_R_cid))
		
		local currentRotorDistance_L = math.sqrt((rotorInversionBase_L_pos.x - rotorMoving_L_pos.x)^2 + (rotorInversionBase_L_pos.y - rotorMoving_L_pos.y)^2 + (rotorInversionBase_L_pos.z - rotorMoving_L_pos.z)^2)	
		local currentRotorDistance_R = math.sqrt((rotorInversionBase_R_pos.x - rotorMoving_R_pos.x)^2 + (rotorInversionBase_R_pos.y - rotorMoving_R_pos.y)^2 + (rotorInversionBase_R_pos.z - rotorMoving_R_pos.z)^2)	
		

		local pistonPos_L = vec3(obj:getNodePosition(pistonPos_L_cid))
		local pistonPos_R = vec3(obj:getNodePosition(pistonPos_R_cid))
		
		local pistonBase_L = vec3(obj:getNodePosition(pistonBase_L_cid))
		local pistonBase_R = vec3(obj:getNodePosition(pistonBase_R_cid))
		
		local pistonLength_L = math.sqrt((pistonPos_L.x - pistonBase_L.x)^2 + (pistonPos_L.y - pistonBase_L.y)^2 + (pistonPos_L.z - pistonBase_L.z)^2)
		local pistonLength_R = math.sqrt((pistonPos_R.x - pistonBase_R.x)^2 + (pistonPos_R.y - pistonBase_R.y)^2 + (pistonPos_R.z - pistonBase_R.z)^2)
		
				
		local pistonExt_L = electrics.values["pistonPos_L"]
		local pistonExt_R = electrics.values["pistonPos_R"]
		
		
		if ( (pedalingEnabled == 1) and (throttle > 0.0 or autoPedal == 1)) then
		
			if(currentRotorDistance_L >= rotorInversionDistance_L) then
				pistonExt_L = -PISTON_EXT
			else
				pistonExt_L = PISTON_EXT
			end
			
			if(currentRotorDistance_R >= rotorInversionDistance_R) then
				pistonExt_R = -PISTON_EXT
			else
				pistonExt_R = PISTON_EXT
			end
			
		end
		

		electrics.values["pistonPos_L"] = pistonExt_L	
		electrics.values["pistonPos_R"] = pistonExt_R	

		
		-------------
		M.manageRing(dt)
		-------------
		

		-------------	
		--Kickstand
		if speed ~= nil and (speed > 10 or electrics.values.kickstand == 1) then 
			electrics.values["kickstand_retract"] = 1 else
			electrics.values["kickstand_retract"] = 0
		end
		
		--Frame holder
		-- for _, beam in pairs(v.data.beams) do if beam.breakgroup == "frame_support_holder" then dump(beam.cid) end end
		if speed ~= nil and (speed > 10 or electrics.values.frame_holder_retract == 1) then 
			electrics.values["frm_hld_retract"] = 1 
		else
			electrics.values["frm_hld_retract"] = 0 
		end
		--------------	
		
		--------------	
		--Crouch
		if electrics.values["crouch_pose_req"] == 0 then
			if electrics.values["clutch_input"] == 1 then
				electrics.values["crouch_pose"] = 1
			else
				electrics.values["crouch_pose"] = 0
			end
		else
			electrics.values["crouch_pose"] = 1
		end
		--------------


	else -- riderFallen	
		electrics.values["throttle"] = 0
		electrics.values["steering_adjusted"] = 0
		electrics.values["wheelerForce"] = 0
		electrics.values["stopperForce"] = 0
		electrics.values["downPressure"] =  0	
		electrics.values["balanceForceRL"] =  0
		electrics.values["balanceForceLR"] =  0
		riderFallen = true
	end

end




local function dataInit()
	print("dataInit")
--local function init(jbeamData)
	
	riderFallen = false
	
	obj:createSFXSource(sound_file, "AudioDefault3D", "ringBell", 1)
	
	electrics.values["crouch_pose_req"] = 0
	electrics.values["currentWheelingDistance"] = 0
	electrics.values["steering_adjusted"] = 0
	electrics.values["wheelie"] = 0
	electrics.values["toggle_wheelie"] = 0	
	electrics.values["wheelerForce"] = 0
	electrics.values["stopperForce"] = 0
	electrics.values["downPressure"] =  0	
	electrics.values["balanceForceRL"] =  0
	electrics.values["balanceForceLR"] =  0
	lastPosition = 0
	

	--function newPIDParallel(kP, 			kI, 		kD, 		minOutput, 	maxOutput, integralInCoef, 			integralOutCoef, 		minIntegral, 		maxIntegral)
	  leanPID = newPIDParallel(0.015, 		0.0,		0.0030, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	  wheeliePID = newPIDParallel(0.015, 	0.00100,	0.005, 		-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	
	local cycletteChosen = false
	
	for k, v in pairs(v.data.activeParts) do
		local partName = k
		if partName == "mtb_ring" then
			ringPresent = true
		else
			if partName == "cyclette_Dummy" then
				autoPedal = 1
				cycletteChosen = true
			end
		end
	end
	
	if cycletteChosen then
		M.limitMAXSpeed			= nop
		M.getSpeedKmh 			= nop
		M.computeTrueLean 		= nop
		M.manageWheelingMeasure = nop
		M.manageWheeling 		= nop
		M.manageLeanLowSpeed 	= nop
		M.manageDownPressure 	= nop
		M.manageRing 			= nop
	else
		M.limitMAXSpeed			= limitMAXSpeed
		M.getSpeedKmh 			= getSpeedKmh
		M.computeTrueLean 		= computeTrueLean
		M.manageWheelingMeasure = manageWheelingMeasure
		M.manageWheeling 		= manageWheeling
		M.manageLeanLowSpeed 	= manageLeanLowSpeed
		M.manageDownPressure 	= manageDownPressure
		M.manageRing 			= manageRing
	end

	electrics.values["pistonPos_R"] = 0
	electrics.values["pistonPos_L"] = 0
	
	local searchNodeName = "pst_r_0"
	
	local rotorInversionDistance_L_cid = 0
	local rotorInversionDistance_R_cid = 0

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonPos_R_cid = v.cid
	  end
	end
	
    searchNodeName = "pst_l_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonPos_L_cid = v.cid
	  end
	end
	
	searchNodeName = "cyl_r_1"
	
	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonBase_R_cid = v.cid
	  end
	end
	
    searchNodeName = "cyl_l_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonBase_L_cid = v.cid
	  end
	end

	
	searchNodeName = "eng_r_13"
	
	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorMoving_R_cid = v.cid
	  end
	end
	
    searchNodeName = "eng_l_10"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorMoving_L_cid = v.cid
	  end
	end
	
	
	
	searchNodeName = "ref_l_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionDistance_L_cid = v.cid
	  end
	end	
	
	
	searchNodeName = "ref_r_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionDistance_R_cid = v.cid
	  end
	end	

	searchNodeName = "ref_l_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionBase_L_cid = v.cid
	  end
	end	
	

	searchNodeName = "ref_r_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionBase_R_cid = v.cid
	  end
	end


	searchNodeName = "hnd_r7"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		ringNode_cid = v.cid
	  end
	end


	local rotorInversionBase_L_pos = vec3(obj:getNodePosition(rotorInversionBase_L_cid))
	local rotorInversionBase_R_pos = vec3(obj:getNodePosition(rotorInversionBase_R_cid))

	local rotorInversionDistance_L_pos = vec3(obj:getNodePosition(rotorInversionDistance_L_cid))	
	local rotorInversionDistance_R_pos = vec3(obj:getNodePosition(rotorInversionDistance_R_cid))	
	
	rotorInversionDistance_R = math.sqrt((rotorInversionDistance_R_pos.x - rotorInversionBase_R_pos.x)^2 + (rotorInversionDistance_R_pos.y - rotorInversionBase_R_pos.y)^2 + (rotorInversionDistance_R_pos.z - rotorInversionBase_R_pos.z)^2)
	rotorInversionDistance_L = math.sqrt((rotorInversionDistance_L_pos.x - rotorInversionBase_L_pos.x)^2 + (rotorInversionDistance_L_pos.y - rotorInversionBase_L_pos.y)^2 + (rotorInversionDistance_L_pos.z - rotorInversionBase_L_pos.z)^2)
	
end

local function reset()
	print("reset")
	dataInit()
end

local function init(jbeamData)
	print("init")
	dataInit()
end

M.init 					= init
M.reset 				= reset
M.updateGFX 			= updateGFX

M.limitMAXSpeed			= limitMAXSpeed
M.getSpeedKmh 			= getSpeedKmh
M.computeTrueLean 		= computeTrueLean
M.manageWheelingMeasure = manageWheelingMeasure
M.manageWheeling 		= manageWheeling
M.manageLeanLowSpeed 	= manageLeanLowSpeed
M.manageDownPressure 	= manageDownPressure
M.manageRing 			= manageRing

return M