local M = {}
local minimumLoggingInterval =  0.125 -- 8 times per second by default
local runningTimer = 0
local timeSinceLastLog = 0

local lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
local IntegralSumManualSteer = 0 --Integral sum, 

local enableLogSteering = 0
local wheelingMeasure = 0
local MAX_SPEED = 400


local Kp_base = 0.01
-- local Ki_base = 0.0001 it gives overshoot after long curves
local Ki_base = 0.0 
local Kd_base = 0.10


local MAX_LEAN = 45



local lastPosition = 0

local prev_keyb_steering = 0
local computed_steering = 0
local KEYB_STEER_INC = 0.005
local KEYB_INPUT = 0
local WHEEL_INPUT = 1
local inputMethod = KEYB_INPUT

local autoPedal = 0

local pedalingEnabled = 1

local rotorInversionDistance_R = 0.0
local rotorInversionDistance_L = 0.0

local PISTON_EXT = 1

local DEBUG_R = false
local DEBUG_L = false

local pistonPos_L_cid = 0
local pistonPos_R_cid = 0

local pistonBase_L_cid = 0
local pistonBase_R_cid = 0

local rotorInversionBase_L_cid = 0
local rotorInversionBase_R_cid = 0

local rotorMoving_R_cid = 0
local rotorMoving_L_cid = 0


local ringNode_cid = 0
local ringPresent = false
local sound_file = "art/ring/ring.wav"

local riderFallen = false



local function brokeBeamsCheck()
    
	for _, b in pairs(v.data.beams) do
		if obj:beamIsBroken(b.cid) and b.breakGroup == "fall" then return true
		end
	end
	return false
	
end


local function manageRing(dt)

	if 	true == ringPresent and electrics.values["ring_bell"] == 1 then	  
		electrics.values["ring_bell"] = 0	
		obj:playSFXOnceStaticCT("ringBell", ringNode_cid, 9, 1, 0, 0)
	end
end


local function init()
	print("init!")
	
	riderFallen = false
	
	obj:createSFXSource(sound_file, "AudioDefault3D", "ringBell", 1)
	
	electrics.values["crouch_pose_req"] = 0
	electrics.values["steeringBike"] = 0
	electrics.values["currentWheelingDistance"] = 0
	lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
	IntegralSumManualSteer = 0 --Integral sum, 
	lastPosition = 0
	timeSinceLastLog = 0
	prev_keyb_steering = 0
	computed_steering = 0
	
	for k, v in pairs(v.data.activeParts) do
		local partName = k
		if partName == "mtb_KeybInput" or partName == "strt_KeybInput" then
			inputMethod = KEYB_INPUT
		else
			if partName == "mtb_WheelInput" or partName == "strt_WheelInput" then
				inputMethod = WHEEL_INPUT
				
			else
				if partName == "mtb_ring" then
					ringPresent = true
				else
					if partName == "cyclette_Dummy" then
						autoPedal = 1
					end
				end
			end
		end	
	end

	electrics.values["pistonPos_R"] = 0
	electrics.values["pistonPos_L"] = 0
	
	local searchNodeName = "pst_r_0"
	
	local rotorInversionDistance_L_cid = 0
	local rotorInversionDistance_R_cid = 0

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonPos_R_cid = v.cid
		if(DEBUG_R) then print("pst_r_0 is :" .. tostring(pistonPos_R_cid)) end
	  end
	end
	
    searchNodeName = "pst_l_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonPos_L_cid = v.cid
		if(DEBUG_L) then print("pst_l_0 is :" .. tostring(pistonPos_L_cid)) end
	  end
	end
	
	searchNodeName = "cyl_r_1"
	
	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonBase_R_cid = v.cid
		if(DEBUG_R) then print("cyl_r_1 is :" .. tostring(pistonBase_R_cid)) end
	  end
	end
	
    searchNodeName = "cyl_l_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		pistonBase_L_cid = v.cid
		if(DEBUG_L) then print("cyl_l_1 is :" .. tostring(pistonBase_L_cid)) end
	  end
	end

	
	searchNodeName = "eng_r_13"
	
	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorMoving_R_cid = v.cid
		if(DEBUG_R) then print("eng_r_13 is :" .. tostring(rotorMoving_R_cid)) end
	  end
	end
	
    searchNodeName = "eng_l_10"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorMoving_L_cid = v.cid
		if(DEBUG_L) then print("eng_l_10 is :" .. tostring(rotorMoving_L_cid)) end
	  end
	end
	
	
	
	searchNodeName = "ref_l_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionDistance_L_cid = v.cid
		if(DEBUG_L) then print("ref_l_1 is :" .. tostring(rotorInversionDistance_L_cid)) end
	  end
	end	
	
	
	searchNodeName = "ref_r_1"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionDistance_R_cid = v.cid
		if(DEBUG_R) then print("ref_r_1 is :" .. tostring(rotorInversionDistance_R_cid)) end
	  end
	end	

	searchNodeName = "ref_l_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionBase_L_cid = v.cid
		if(DEBUG_L) then print("ref_l_0 is :" .. tostring(rotorInversionBase_L_cid)) end
	  end
	end	
	

	searchNodeName = "ref_r_0"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		rotorInversionBase_R_cid = v.cid
		if(DEBUG_R) then print("ref_r_0 is :" .. tostring(rotorInversionBase_R_cid)) end
	  end
	end


	searchNodeName = "hnd_r7"

	for k,v in pairs(v.data.nodes) do
	  if v.name == searchNodeName then
		ringNode_cid = v.cid
		if(DEBUG_R) then print("hnd_r7 is :" .. tostring(ringNode_cid)) end
	  end
	end


	local rotorInversionBase_L_pos = vec3(obj:getNodePosition(rotorInversionBase_L_cid))
	local rotorInversionBase_R_pos = vec3(obj:getNodePosition(rotorInversionBase_R_cid))

	local rotorInversionDistance_L_pos = vec3(obj:getNodePosition(rotorInversionDistance_L_cid))	
	local rotorInversionDistance_R_pos = vec3(obj:getNodePosition(rotorInversionDistance_R_cid))	
	
	rotorInversionDistance_R = math.sqrt((rotorInversionDistance_R_pos.x - rotorInversionBase_R_pos.x)^2 + (rotorInversionDistance_R_pos.y - rotorInversionBase_R_pos.y)^2 + (rotorInversionDistance_R_pos.z - rotorInversionBase_R_pos.z)^2)
	rotorInversionDistance_L = math.sqrt((rotorInversionDistance_L_pos.x - rotorInversionBase_L_pos.x)^2 + (rotorInversionDistance_L_pos.y - rotorInversionBase_L_pos.y)^2 + (rotorInversionDistance_L_pos.z - rotorInversionBase_L_pos.z)^2)
	
	if(DEBUG_L) then print("rotorInversionDistance_L is :" .. tonumber(string.format("%.4f", rotorInversionDistance_L))) end
	if(DEBUG_R) then print("rotorInversionDistance_R is :" .. tonumber(string.format("%.4f", rotorInversionDistance_R))) end
	
end

local function reset()
	print("reset!")
	init()
end


local function getSpeedKmh()

return obj:getVelocity():length()*3.6

end


local function limitMAXSpeed()

	local speed = getSpeedKmh()

	if speed > MAX_SPEED then
		electrics.values["throttle"] = 0
	end
end


local function manageWheeling(dt)

	if electrics.values["wheeling_count"] == 1 then
		if wheelingMeasure == 0 then
			wheelingMeasure = 1 
			gui.message("Start measuring wheeling ...")
		end
	
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->left
		local wheeling = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no x terms
		local trueWheeling = math.deg(math.asin(wheeling))
	
	
		if trueWheeling > 10 then
			local newPosition = obj:getPosition()
			local distance = math.sqrt( (newPosition.x - lastPosition.x) * (newPosition.x - lastPosition.x) + (newPosition.y - lastPosition.y) * (newPosition.y - lastPosition.y))
			local currentWheelingDistance = electrics.values["currentWheelingDistance"] + distance
			electrics.values["currentWheelingDistance"] = currentWheelingDistance
			lastPosition = obj:getPosition()
		else
			lastPosition = obj:getPosition()
		end
	end
	
	if electrics.values["wheeling_count"] == 0 then
		if wheelingMeasure == 1 then
			wheelingMeasure = 0 
			gui.message("Stop measuring wheeling ...")
		end
	end		
		
end


local function computeKeybInputSteering(dt)
	
	local cur_keyb_steering = electrics.values["steering_input"]
	
	if (cur_keyb_steering > computed_steering) then
		computed_steering = computed_steering + KEYB_STEER_INC
		if computed_steering > 1 then
			computed_steering = 1
		end
	else
		if (cur_keyb_steering < computed_steering) then
			computed_steering = computed_steering - KEYB_STEER_INC
			if computed_steering < -1 then
				computed_steering = -1
			end
		end
	end
	
	if math.abs(computed_steering) < KEYB_STEER_INC then
		computed_steering = 0
	end
	
--	timeSinceLastLog = timeSinceLastLog + dt
--	runningTimer = runningTimer + dt
		  
--	if timeSinceLastLog >= minimumLoggingInterval then
--		timeSinceLastLog = 0
--		print("cur_keyb_steering:" .. cur_keyb_steering .. " prev_keyb_steering:" .. prev_keyb_steering .. " computed_steering:" .. computed_steering)
--	end
	
	
--	prev_keyb_steering = cur_keyb_steering
	
	return computed_steering
end

local function manageSteering(speed, steering, dt)

	local steering_output = 0

	if speed > 15 then

		--adjust kd in function of speed, the higher speed, the more effective derivative we need 
		local Kd_adjusted = Kd_base + speed/8000
	
		local targetLean = -steering*MAX_LEAN --max lean angle is MAX_LEAN degrees
		local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
		
		--pitch is between -1 (down) and 1 (pointing up), with 0 point at the horizon
		--roll is also between -1 and 1, with 0 being level, and -1 & 1 being opposing sides of the horizon 
		
		local trueLean = math.deg(math.asin(lean))
		local errorLean = targetLean - trueLean
		

		--Integral controller
		
		local PID_P = Kp_base * errorLean   -- calculate the P part
		-- calculate the IntegralSumManualSteer
		IntegralSumManualSteer = IntegralSumManualSteer + errorLean  -- * dt
		-- integral  saturation
			if math.abs(IntegralSumManualSteer) > 1000 then
			if IntegralSumManualSteer > 0 then
				IntegralSumManualSteer = 1000 
			elseif IntegralSumManualSteer < 0 then
				IntegralSumManualSteer = -1000
			end
		end

		local PID_I = Ki_base * IntegralSumManualSteer
	   
		-- the D part 
		local PID_D = (Kd_adjusted * (errorLean - lastErrorLeanManualSteer))  -- / dt
		-- P+I+D
		-- map the PID value to Thrust position value [ -1, 1] , -1 is the max throttle,
		steering_output = PID_P + PID_I + PID_D
		
		--print("IN:" .. steering .. " OUT:" .. steering_output)
		--update some value
		lastErrorLeanManualSteer = errorLean
			
		--log('I', "controller.lua", string.format('vec3(%s,%s,%s)', V.x, V.y, V.z))
		--log('I', "controller.lua", "true_lean: " .. tostring(trueLean) .. "steering_out: " .. tostring(steering_output))

		if enableLogSteering == 1  then 
		--	timeSinceLastLog = timeSinceLastLog + dt
			runningTimer = runningTimer + dt
		  
--			if timeSinceLastLog >= minimumLoggingInterval then
	--		 timeSinceLastLog = 0
			 
			 
			 --local pos = obj:getPosition()
			 
			 logLine(
				 tonumber(string.format("%.5f", runningTimer)),
				 tonumber(string.format("%.5f", speed)),
				 tonumber(string.format("%.5f", electrics.values["steering_input"])),
				 tonumber(string.format("%.5f", input.throttle)),
				 tonumber(string.format("%.5f", targetLean)),
				 tonumber(string.format("%.5f", trueLean)),
				 tonumber(string.format("%.5f", errorLean)),
				 tonumber(string.format("%.5f", lastErrorLeanManualSteer)),
				 tonumber(string.format("%.5f", PID_P)),
				 tonumber(string.format("%.5f", PID_D)),				 
				 tonumber(string.format("%.5f", electrics.values["steeringBike"]))
			 )
			--end
		
		end
		
	else
		steering_output = steering
	end
	
	return steering_output

end



local function updateGFX(dt)


	if riderFallen == false and false == brokeBeamsCheck() then
	
		local throttle = electrics.values["throttle"]

		local rotorInversionBase_L_pos = vec3(obj:getNodePosition(rotorInversionBase_L_cid))
		local rotorInversionBase_R_pos = vec3(obj:getNodePosition(rotorInversionBase_R_cid))
		
		local rotorMoving_L_pos = vec3(obj:getNodePosition(rotorMoving_L_cid))
		local rotorMoving_R_pos = vec3(obj:getNodePosition(rotorMoving_R_cid))
		
		local currentRotorDistance_L = math.sqrt((rotorInversionBase_L_pos.x - rotorMoving_L_pos.x)^2 + (rotorInversionBase_L_pos.y - rotorMoving_L_pos.y)^2 + (rotorInversionBase_L_pos.z - rotorMoving_L_pos.z)^2)	
		local currentRotorDistance_R = math.sqrt((rotorInversionBase_R_pos.x - rotorMoving_R_pos.x)^2 + (rotorInversionBase_R_pos.y - rotorMoving_R_pos.y)^2 + (rotorInversionBase_R_pos.z - rotorMoving_R_pos.z)^2)	
		

		local pistonPos_L = vec3(obj:getNodePosition(pistonPos_L_cid))
		local pistonPos_R = vec3(obj:getNodePosition(pistonPos_R_cid))
		
		local pistonBase_L = vec3(obj:getNodePosition(pistonBase_L_cid))
		local pistonBase_R = vec3(obj:getNodePosition(pistonBase_R_cid))
		
		local pistonLength_L = math.sqrt((pistonPos_L.x - pistonBase_L.x)^2 + (pistonPos_L.y - pistonBase_L.y)^2 + (pistonPos_L.z - pistonBase_L.z)^2)
		local pistonLength_R = math.sqrt((pistonPos_R.x - pistonBase_R.x)^2 + (pistonPos_R.y - pistonBase_R.y)^2 + (pistonPos_R.z - pistonBase_R.z)^2)
		
				
		local pistonExt_L = electrics.values["pistonPos_L"]
		local pistonExt_R = electrics.values["pistonPos_R"]
		
		
		if(DEBUG_R or DEBUG_L) then
			timeSinceLastLog = timeSinceLastLog + dt
			if timeSinceLastLog >= minimumLoggingInterval then
				timeSinceLastLog = 0
				if(DEBUG_L) then 
					print("pistonLength_L: " .. tonumber(string.format("%.4f", pistonLength_L)) .. 
						" pistonExt_L " .. tonumber(string.format("%.4f", pistonExt_L)) .. 
						" dist_L " .. tonumber(string.format("%.4f", currentRotorDistance_L)) .. 
						" direction_L " .. tostring(currentRotorDistance_L >= rotorInversionDistance_L)) 
				end
				
				if(DEBUG_R) then 
					print("pistonLength_R: " .. tonumber(string.format("%.4f", pistonLength_R)) .. 
						" pistonExt_R " .. tonumber(string.format("%.4f", pistonExt_R)) .. 
						" dist_R " .. tonumber(string.format("%.4f", currentRotorDistance_R)) .. 
						" direction_R " .. tostring(currentRotorDistance_R >= rotorInversionDistance_R)) 
				end
				
				
			end
		end		
		
		
		
		if ( (pedalingEnabled == 1) and (throttle > 0.0 or autoPedal == 1)) then
		
			if(currentRotorDistance_L >= rotorInversionDistance_L) then
				pistonExt_L = -PISTON_EXT
			else
				pistonExt_L = PISTON_EXT
			end
			
			if(currentRotorDistance_R >= rotorInversionDistance_R) then
				pistonExt_R = -PISTON_EXT
			else
				pistonExt_R = PISTON_EXT
			end
			
		end
		

		electrics.values["pistonPos_L"] = pistonExt_L	
		electrics.values["pistonPos_R"] = pistonExt_R	

		
		local speed = getSpeedKmh()
		

		----------
		limitMAXSpeed()
		----------
		
		-------------
		manageWheeling(dt)
		-------------
		
		-------------
		manageRing(dt)
		-------------


		if 	inputMethod == KEYB_INPUT then
			-- Keyboard/Controller steering
			local steering = computeKeybInputSteering(dt) 
			local steeringOutput = manageSteering(speed, steering, dt)

			electrics.values["steeringBikeKeyb"] = steeringOutput

			-- print("steeringK: " .. steering .. "steeringOutput: " .. steeringOutput)
		else
			-- Steering Wheel steering
			local steering = electrics.values["steering_input"]
			local steeringOutput = manageSteering(speed, steering, dt)

			electrics.values["steeringBikeWheel"] = steeringOutput
			
			-- print("steeringW: " .. steering .. "steeringOutput: " .. steeringOutput)
		end
		

		-------------	
		--Kickstand
		if speed > 10 or electrics.values.kickstand == 1 then 
			electrics.values["kickstand_retract"] = 1 else
			electrics.values["kickstand_retract"] = 0
		end
		
		--Frame holder
		-- for _, beam in pairs(v.data.beams) do if beam.breakgroup == "frame_support_holder" then dump(beam.cid) end end
		if speed > 10 or electrics.values.frame_holder_retract == 1 then 
			electrics.values["frm_hld_retract"] = 1 
		else
			electrics.values["frm_hld_retract"] = 0 
		end
		--------------	
		
		
		
		--------------	
		--Crouch
		if electrics.values["crouch_pose_req"] == 0 then
			if electrics.values["clutch_input"] == 1 then
				electrics.values["crouch_pose"] = 1
			else
				electrics.values["crouch_pose"] = 0
			end
		else
			electrics.values["crouch_pose"] = 1
		end
		--------------


	else -- riderFallen	
		electrics.values["throttle"] = 0
		electrics.values["steeringBikeWheel"] = 0
		electrics.values["steeringBikeKeyb"] = 0
		riderFallen = true
	end

end



M.onInit = init
M.onReset = reset
M.updateGFX = updateGFX

return M