-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local originalParkTorque = 0

local function updateGFX()
    if electrics.values.parkingbrakeL ~= 0 or electrics.values.parkingbrakeR ~= 0 then
        input.parkingbrake = 1
        electrics.values.parkingbrake = 1
        for _, wd in pairs(wheels.wheels) do
            if wd.name == "RL" then
                wd.parkingTorque = originalParkTorque * electrics.values.parkingbrakeL
            elseif wd.name == "RR" then
                wd.parkingTorque = originalParkTorque * electrics.values.parkingbrakeR
            end
        end
    end
end

local function init()
    electrics.values.parkingbrakeL = 1
    electrics.values.parkingbrakeR = 1

    local rl
    local rr
    for _, wd in pairs(wheels.wheels) do
        if wd.name == "RL" then
            rl = wd.parkingTorque
        elseif wd.name == "RR" then
            rr = wd.parkingTorque
        end
    end
    originalParkTorque = (rl + rr) / 2
end

local function reset()
    electrics.values.parkingbrakeL = 1
    electrics.values.parkingbrakeR = 1
end

-- public interface
M.updateGFX = updateGFX
M.init = init
M.reset = reset

return M