local M = {}

M.type = "auxiliary"
M.defaultOrder = 500

local rpm = 0

local outputmin = 0
local outputmax = 1
local thrust = 0
electrics.values.tng_jet = 0

local function init(jbeamData)
min = jbeamData.min or 2700
max = jbeamData.max or 6000
end

local function rpmthrust(rpm, min, max, outputmin, outputmax)
  local output = (rpm - min) / (max - min) * (outputmax - outputmin) + outputmin
  return output
end

local function updateGFX(dt)
  rpm = electrics.values.rpm

  if rpm >= min then
    thrust = rpmthrust(rpm, min, max, outputmin, outputmax)
  else
    thrust = 0
  end
 
  electrics.values.tng_jet = thrust * electrics.values.throttle_input

end

M.updateGFX = updateGFX
M.init = init
return M
