local M = {}

local function onInit()
	electrics.values.cornerlight_L = 0
	electrics.values.cornerlight_R = 0
end

local function onReset()
	onInit()
end

local function updateGFX(dt)
    if electrics.values.ignitionLevel <= 1 then
        electrics.values.cornerlight_L = 0
        electrics.values.cornerlight_R = 0
    elseif electrics.values.wheelspeed > 60/3.6 then
        electrics.values.cornerlight_L = 0
        electrics.values.cornerlight_R = 0
    elseif electrics.values.steering < -75 or (electrics.values.wheelspeed < 30/3.6 and electrics.values.signal_right_input == 1 and electrics.values.hazard_enabled == 0) then
        electrics.values.cornerlight_R = 1
    elseif electrics.values.steering > 75 or (electrics.values.wheelspeed < 30/3.6 and electrics.values.signal_left_input == 1 and electrics.values.hazard_enabled == 0) then
        electrics.values.cornerlight_L = 1
    else
        electrics.values.cornerlight_L = 0
        electrics.values.cornerlight_R = 0
    end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX
return M
