-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    electrics.values['lifter'] = 1
    electrics.values['lifter_input'] = 0
end

local function updateGFX(dt)
    electrics.values['lifter'] = math.min(1, math.max(-0.0, (electrics.values['lifter'] + electrics.values['lifter_input'] * dt * 1)))
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M