-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local blinkTimerThreshold_1 = 0.1
local blinkTimerThreshold_2 = 0.2
local blinkTimerThreshold_3 = 0.3
local blinkTimerThreshold_4 = 0.4
local blinkTimerThreshold_5 = 0.5
local blinkTimerThreshold_6 = 0.8
local blinkTimer = 0
local blinkPulse_1 = 0
local blinkPulse_2 = 0
local blinkPulse_3 = 0
local blinkPulse_4 = 0
local blinkPulse_5 = 0
local signalMode = nil

local function onInit()
  electrics.values['l_section1'] = 0
  electrics.values['l_section2'] = 0
  electrics.values['l_section3'] = 0
  electrics.values['l_section4'] = 0
  electrics.values['l_section5'] = 0
  electrics.values['r_section1'] = 0
  electrics.values['r_section2'] = 0
  electrics.values['r_section3'] = 0
  electrics.values['r_section4'] = 0
  electrics.values['r_section5'] = 0
end

local function generateBlinkPulse(dt)
  blinkTimer = blinkTimer + dt
  if blinkTimer > blinkTimerThreshold_1 then
    blinkPulse_1 = 1
  end
  if blinkTimer > blinkTimerThreshold_2 then
    blinkPulse_2 = 1
  end
  if blinkTimer > blinkTimerThreshold_3 then
    blinkPulse_3 = 1
  end
  if blinkTimer > blinkTimerThreshold_4 then
    blinkPulse_4 = 1
  end
  if blinkTimer > blinkTimerThreshold_5 then
    blinkPulse_5 = 1
  end
  if blinkTimer > blinkTimerThreshold_6 then
    blinkPulse_1 = 0  
	blinkPulse_2 = 0
	blinkPulse_3 = 0
	blinkPulse_4 = 0
	blinkPulse_5 = 0
    blinkTimer = 0
  end
end

local function reset()
  onInit()
end

local function updateGFX(dt)
	generateBlinkPulse(dt)
	electrics.values['l_section1'] = (electrics.values["signal_left_input"] == 1 and blinkPulse_1)
	electrics.values['l_section2'] = (electrics.values["signal_left_input"] == 1 and blinkPulse_2)
	electrics.values['l_section3'] = (electrics.values["signal_left_input"] == 1 and blinkPulse_3)
	electrics.values['l_section4'] = (electrics.values["signal_left_input"] == 1 and blinkPulse_4)
	electrics.values['l_section5'] = (electrics.values["signal_left_input"] == 1 and blinkPulse_5)
	
	electrics.values['r_section1'] = (electrics.values["signal_right_input"] == 1 and blinkPulse_1)
	electrics.values['r_section2'] = (electrics.values["signal_right_input"] == 1 and blinkPulse_2)
	electrics.values['r_section3'] = (electrics.values["signal_right_input"] == 1 and blinkPulse_3)
	electrics.values['r_section4'] = (electrics.values["signal_right_input"] == 1 and blinkPulse_4)
	electrics.values['r_section5'] = (electrics.values["signal_right_input"] == 1 and blinkPulse_5)
	if electrics.values["signal_right_input"] == 0 and electrics.values["signal_left_input"] == 0 then
		blinkPulse_1 = 0  
		blinkPulse_2 = 0
		blinkPulse_3 = 0
		blinkPulse_4 = 0
		blinkPulse_5 = 0
		blinkTimer = 0
	end
end

-- public interface
M.onInit    = onInit
M.reset   = reset
M.updateGFX = updateGFX

return M