-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}

local logTag = 'agentTrafficTool'
local im = ui_imgui
local ffi = require("ffi")

local colorWarning, colorError = im.ImVec4(1, 1, 0, 1), im.ImVec4(1, 0, 0, 1)

--combo
local groupsTable = {}

local currentGroup = nil

local groupString = ""

local selectedGroup = im.IntPtr(0)
local varAmount = im.FloatPtr(0)

local selectedPlates = im.IntPtr(0)
local platesString = "Front Plates\0No Front Plates\0Random Front Plates\0"

local selectedPlateShape = im.IntPtr(0)
local plateShapeString = "Standard\0Small Italian 36x11 Front Plates\0Mercosur-Mercosul 40x13 Plates\0Yellow UK/French Rear Plates\0Yellow Cypriot Rear Plates\0"
local plateShapeInstalled = false
local plateShapeSupported = false


--TEMPORARY TESTER DUMMY THING
local licensePlates = {}
local selectedPlateDesign = im.IntPtr(0)
local plateDesignString = "Map Plate Design\0"
local plateSkip = settings.getValue('SkipGenerateLicencePlate')

local platesOnSpawn = false
local platesOnSpawnEnabled = im.BoolPtr(platesOnSpawn)

local plateReplaceUSF = '_licenseplate_F_US'
local plateReplaceUSR = '_licenseplate_F_US'

local quickStart = false
local quickStartEnabled = im.BoolPtr(quickStart)

local alreadySpawned = false
local alreadySpawnedWarning = false

local usePooling = settings.getValue('trafficExtraVehicles') or false
local usePoolingNumber = settings.getValue('trafficExtraAmount') or 0
local usePoolingEnabled = im.BoolPtr(usePooling)
local varPooling = im.FloatPtr(0)

local includeParked = core_settings_settings.getValue('trafficParkedVehicles') or false
local includeParkedNumber = core_settings_settings.getValue('trafficParkedAmount') or 0
local includeParkedEnabled = im.BoolPtr(includeParked)
local varParked = im.FloatPtr(0)

local levelSpots = 0
local maxParked = 128 --fallback value

local includeService = false
local forcePolice = false

local currentPlateRegion = ""

local vehicleAmount = core_settings_settings.getValue('trafficAmount') or 0

--if trafficAmount is auto use thread count
if vehicleAmount == 0 then vehicleAmount = Engine.Platform.getCPUInfo().coresLogical - 1 end
if usePoolingNumber == 0 then usePoolingNumber = Engine.Platform.getCPUInfo().coresLogical - 1 end
if includeParkedNumber == 0 then includeParkedNumber = Engine.Platform.getCPUInfo().coresLogical*2 end

local agentTrafficActive = false

--independent GUI
local showUI = nil
local tempFloat = nil

local appTitle = " Agent Traffic Tool v1"

local function setPopulation(group)
  local vehicleData = {}
  vehicleData.countryRatios = {}
  vehicleData.popTotal = 0
  local countryEntries = 0
  local lastPopMin = 0
  for i,h in pairs(group.data) do
    local model = h.model
    local country = core_vehicles.getModel(model).model.Country
    if country and country ~= 'default' then
      countryEntries = countryEntries + 1
      vehicleData.countryRatios[country] = (vehicleData.countryRatios[country] or 0) + 1 -- counts up country of origin entries
    end
    for n, config in pairs(h) do
      local configCopy = deepcopy(core_vehicles.getModel(model).configs[config])
      if configCopy then
        local popMin = lastPopMin+1
        local popMax = lastPopMin+1+configCopy.Population
        table.insert(vehicleData, {
          model = model,
          config = config,
          country = country,
          pop = configCopy.Population,
          popRange = {popMin, popMax}
        })
        if popMax > vehicleData.popTotal then
          vehicleData.popTotal = popMax
        end
        lastPopMin = popMax
      end
    end
  end
  for k, v in pairs(vehicleData.countryRatios) do
    vehicleData.countryRatios[k] = v / math.max(1, countryEntries) -- this value is used to improve probability bias of vehicles with a rarer country of origin
  end
  vehicleData.tags = group.tags
  vehicleData.name = group.name
  return vehicleData
end

local function getIndexRandomPop(data, selected)
  local randNum = math.random(1, data.popTotal)
  for i, v in ipairs(data) do
    local range = deepcopy(v.popRange)
    if selected and selected[v.config] then
      range[2] = range[2] / selected[v.config]
      range[1] = range[1] / selected[v.config]
    end
    if range[1] <= randNum and range[2] >= randNum then
      return i
    end
  end
end

local function buildGroup(data, amount)
  -- popFactor: higher number means rare cars used faster in small spawn groups
  local popFactor = 10
  local finalGroup = {}
  local newGroup = {}
  local modelIdx
  local selected = {}

  table.sort(data, function(a, b) return a.pop > b.pop end) -- for optimized index searching
  repeat
    modelIdx = getIndexRandomPop(data, selected)
    local model = data[modelIdx]
    if model then
      if not selected[model.config] then selected[model.config] = popFactor end
      selected[model.config] = selected[model.config] + popFactor
      local entry = {model = model.model, config = model.config}
      entry.modelPop = model.pop
      table.insert(newGroup, entry)
    end
  until #newGroup == amount
  local selectedAmnt = 0
  for k,v in pairs(selected) do
    selectedAmnt = selectedAmnt + 1
  end
  finalGroup.data = newGroup
  finalGroup.tags = data.tags
  log('I', logTag, "Used "..tostring(selectedAmnt).. " out of "..tostring(#data).." configs to make a list of "..tostring(amount).." vehicles for "..data.name.." group.")
  return finalGroup
end

local function prepareGroup(isParked)
  currentGroup = groupsTable[selectedGroup[0]+1]
  if currentGroup ~= nil then
    local targetAmount = vehicleAmount
    if usePooling == true then
      targetAmount = vehicleAmount + usePoolingNumber
    end
    if isParked and isParked == true then
      targetAmount = includeParkedNumber
    end
    --dump(buildGroup(setPopulation(currentGroup), targetAmount))
    currentGroup = buildGroup(setPopulation(currentGroup), targetAmount)
    --for data in table currentGroup
    for k,v in pairs(currentGroup.data) do
      --dump(jsonReadFile('/vehicles/'..v.model..'/'..v.config..'.pc'))
      --we set config bit table as table from config pc file so we can access it later and edit
      --if not type(v.config) == "table" then
      v.config = jsonReadFile('/vehicles/'..v.model..'/'..v.config..'.pc')
      --end
      -- you should do that later for parked vehicles specifically, you need to spawn separate "parked" group with altered configs in lua and proper options passed in multispawn system
    end
    for p,q in pairs (currentGroup.tags) do
      if string.find(q, "agent_region_eu") then
        currentPlateRegion = "eu"
      elseif string.find(q, "agent_region_gb") or string.find(q, "agent_region_uk") then
        currentPlateRegion = "gb"
      elseif string.find(q, "agent_region_br") or string.find(q, "agent_region_sa") then
        currentPlateRegion = "sa"
      else
        currentPlateRegion = "us"
      end
    end

    for p,q in pairs (currentGroup.tags) do
      if string.find(q, "agent_platenaming_basic") then
        plateReplaceUSF = '_licenseplate_F'
        plateReplaceUSR = '_licenseplate_R'
        plateShapeInstalled = false
        plateShapeSupported = false
      else
        plateReplaceUSF = '_licenseplate_F_US'
        plateReplaceUSR = '_licenseplate_R_US'
        plateShapeSupported = true
      end
    end
  else
    log('E', logTag, "Group is missing!!!")
  end
end

--parts switching functions
local function preparePartsPlates(currentGroup)
  for k,v in pairs(currentGroup.data) do
    if v.config and v.config.parts then
      local parts = v.config.parts
      for s,p in pairs(parts) do

        --twotone fixing while its at it
        if string.find(p, "_twotone_standard") then
          v.config.parts[s] = string.gsub(p, "_twotone_standard", "_twotone_traffic")
        end

        --eu plates
        if string.find(p, plateReplaceUSF) and currentPlateRegion == "eu" then
          v.config.parts[s] = string.gsub(p, plateReplaceUSF, "_licenseplate_F_EU")
        end
        if string.find(p, plateReplaceUSR) and currentPlateRegion == "eu" then
          v.config.parts[s] = string.gsub(p, plateReplaceUSR, "_licenseplate_R_EU")
        end

        if string.find(p, plateReplaceUSF) and currentPlateRegion == "gb" then
          v.config.parts[s] = string.gsub(p, plateReplaceUSF, "_licenseplate_F_EU")
        end
        if string.find(p, plateReplaceUSR) and currentPlateRegion == "gb" then
          v.config.parts[s] = string.gsub(p, plateReplaceUSR, "_licenseplate_R_EU")
        end

        --us/japanese regular square plates
        if string.find(p, "_licenseplate_F_EU") and currentPlateRegion == "us" then
          v.config.parts[s] = string.gsub(p, "_licenseplate_F_EU", plateReplaceUSF)
        end
        if string.find(p, "_licenseplate_R_EU") and currentPlateRegion == "us" then
          v.config.parts[s] = string.gsub(p, "_licenseplate_R_EU", plateReplaceUSR)
        end

        --fix official naming being shitty for us plates
        if string.find(p, "_EU_EU") then
          v.config.parts[s] = string.gsub(p, "_EU_EU", "_EU")
        end

        --us front plate randomisation
        if selectedPlates[0] == 2 then --random plates option
          local platesRandom = math.random(0, 2)
          if platesRandom == 2 then
            if string.find(s, "_licenseplate_F") then v.config.parts[s] = "" end
          end
        end
        if selectedPlates[0] == 1 then --no plates option
          if string.find(s, "_licenseplate_F") then v.config.parts[s] = "" end
        end
        --selected plate design from ui
        if selectedPlateDesign[0] ~= 0 then
          if string.find(s, "licenseplate_design_2_1") then v.config.parts[s] = licensePlates[selectedPlateDesign[0]].id end
        end

        --mod plate shape stuff
        if plateShapeInstalled == true and plateShapeSupported == true then
          if selectedPlateShape[0] == 1 then --italian small front plates
            if string.find(p, "_licenseplate_F_EU") then
              v.config.parts[s] = string.gsub(p, "_licenseplate_F_EU", "_licenseplate_F_IT")
            end
            if string.find(s, "licenseplate_design_2_1") then
              v.config.parts[s] = "license_plate_italy_1999_2_1"
            end
          end

          if selectedPlateShape[0] == 2 then --mercosur plates
            if string.find(p, "_licenseplate_F_EU") then
              v.config.parts[s] = string.gsub(p, "_licenseplate_F_EU", "_licenseplate_F_SA")
            end
            if string.find(p, "_licenseplate_R_EU") then
              v.config.parts[s] = string.gsub(p, "_licenseplate_R_EU", "_licenseplate_R_SA")
            end
          end

          if selectedPlateShape[0] == 3 then --british rear yellow
            if string.find(p, "_licenseplate_R_EU") then
              v.config.parts[s] = p..'_yellow'
            end
          end

          if selectedPlateShape[0] == 4 then --cyprus reversed rear yellow
            if string.find(p, "_licenseplate_F_EU") then
              v.config.parts[s] = p..'_white'
            end
          end

        end
      end
    end
  end
end

local function preparePartsParked(parkedGroup)
  for k,v in pairs(parkedGroup.data) do
    if v.config and v.config.parts then
      local parts = v.config.parts
      for s,p in pairs(parts) do
        if string.find(s, "_controller") then v.config.parts[s] = "" end
        if string.find(s, "_engine") then v.config.parts[s] = "" end
        if string.find(s, "_transmission") then v.config.parts[s] = "" end
        if string.find(s, "_drivetrain") then v.config.parts[s] = "" end
        if string.find(p, "_wheels_F") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(p, "_wheels_R") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(p, "_hubcaps_F") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(p, "_hubcaps_R") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(s, "_hubcaps_F") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(s, "_hubcaps_R") then
          v.config.parts[s] = p..'_parked'
        end
        if string.find(p, "_steeringbox") then
          v.config.parts[s] = p..'_parked'
        end
      end
    end
  end
end

local function onGroupDataLoad()
  --we need to clear some data
  groupsTable = {}
  currentGroup = nil
  groupString = ""
  local groupFiles = FS:findFiles('/vehicleGroups/agentTraffic/', '*.vehGroup.json', 1, true, false)
  for k,filename in pairs(groupFiles) do
    groupsTable[k] = jsonReadFile(filename) or {}
  end

  local groupNames = {}
  for k,v in pairs(groupsTable) do
    table.insert(groupNames, groupsTable[k].name)
  end

  local groupAmount = 0
  for k,v in ipairs(groupNames) do
    groupAmount = groupAmount + 1
    groupString = groupString..v.."\0"
  end
end

--licensePlate finder
local function getAvailableLicensePlates()
  local jbeamFiles = FS:findFiles('/vehicles/common/', '*.jbeam', 2, true, false)
  for k,filename in pairs(jbeamFiles) do
    local jbeamData = jsonReadFile(filename) or {}
    for k,v in pairs(jbeamData) do
      if v.slotType and v.slotType == 'licenseplate_design_2_1' then
        if v.information and v.information.name then
          table.insert(licensePlates, {id = k, name = v.information.name})
        end
      end
    end
  end
  table.sort(licensePlates, function(a,b) return string.upper(a.name) < string.upper(b.name) end)
  for k,v in pairs(licensePlates) do
    plateDesignString = plateDesignString..v.name..'\0'
  end
end

local reloadPlatesJob

local function reloadPlates(job)
  job.count = 0
  job.progress = 0
  local parkedCarsList = extensions.gameplay_parking.getParkedCarsList()
  local trafficList = extensions.gameplay_traffic.getTrafficList()
  for k,v in pairs(parkedCarsList) do
    job.count = job.count  + 1
  end
  for k,v in pairs(trafficList) do
    job.count = job.count  + 1
  end
  job.sleep(3)
  for _, id in pairs(parkedCarsList) do
    job.sleep(0.1)
    core_vehicles.setPlateText(core_vehicles.regenerateVehicleLicenseText(be:getObjectByID(id)), id)
    job.progress = job.progress + 1
  end
  for _, id in pairs(trafficList) do
    job.sleep(0.1)
    core_vehicles.setPlateText(core_vehicles.regenerateVehicleLicenseText(be:getObjectByID(id)), id)
    job.progress = job.progress + 1
  end
end

local function spawnParked()
  onGroupDataLoad()
  prepareGroup(true)
  preparePartsPlates(currentGroup)
  local parkedGroup = currentGroup
  preparePartsParked(parkedGroup)
  extensions.core_multiSpawn.spawnGroup(parkedGroup.data, includeParkedNumber, {name = 'autoParking', mode = "roadBehind", shuffle = false, gap = 20, instant = true, configPopPower = 10})
  extensions.gameplay_parking.scatterParkedCars(extensions.gameplay_parking.getParkedCarsList(), 0, 2000)
end

local function startTraffic()
  extensions.gameplay_traffic.activate()
  if usePooling == true then
    extensions.gameplay_traffic.setActiveAmount(vehicleAmount)
  end
  extensions.gameplay_traffic.scatterTraffic(extensions.gameplay_traffic.getTrafficList(), 0, 2000)
  if platesOnSpawn == false then
    reloadPlatesJob = extensions.core_jobsystem.create(reloadPlates, 1)
  end
end

local function getTrafficAmnt()
  local amount = 64
  local trafficList = extensions.gameplay_traffic.getTrafficList()
  local parkedList = extensions.gameplay_parking.getParkedCarsList()
  if trafficList and parkedList then
    amount = 0
    for k,v in pairs(trafficList) do
      amount = amount + 1
    end
    for k,v in pairs(parkedList) do
      amount = amount + 1
    end
  end
  return amount
end

local function getParkingSpots()
  local spots = extensions.gameplay_parking.getParkingSpots()
  local count = 0
  if spots and spots.byName then
    for k,v in pairs(spots.byName) do
      count = count + 1
    end
  end
  levelSpots = count
  if levelSpots > 0 then
    maxParked = levelSpots
  end
  if levelSpots >= 128 then
    maxParked = 128
  end
  if includeParkedNumber >= maxParked then
    includeParkedNumber = maxParked
  end
end

-- You can test vehicles by calling extensions.core_agentTrafficTool.testGroup(zOffset) or extensions.core_agentTrafficTool.testGroup()

local function testGroup(zOffset)
  log('I', logTag, "Starting test")
  if selectedGroup[0] and groupsTable[selectedGroup[0]+1] then
    if groupsTable[selectedGroup[0]+1].name and groupsTable[selectedGroup[0]+1].data then
      log('I', logTag, "Starting with a selected group: "..groupsTable[selectedGroup[0]+1].name)
      local spawnOptions = {}
      local mainPos = core_camera.getPosition()
      spawnOptions.autoEnterVehicle = false
      local count = 0
      for k,v in pairs(groupsTable[selectedGroup[0]+1].data) do
        spawnOptions.config = v.config
        spawnOptions.pos = mainPos + vec3(0, count, 0)
        if zOffset then spawnOptions.pos = spawnOptions.pos +  vec3(0, 0, zOffset) end
        core_vehicles.spawnNewVehicle(v.model, spawnOptions)
        count = count + 1.5
      end
    else
      log('E', logTag, "Group is corrupted")
    end
  else
    log('E', logTag, "None of groups are selected or table is missing")
  end
end

--FROM TRAFFIC MANAGER - fancy json fixer stuff thanks ck for finding

--do stuff after extension gets loaded
local function onExtensionLoaded()
  onGroupDataLoad()
  getAvailableLicensePlates()
  getParkingSpots()
  if groupsTable and selectedGroup[0] and groupsTable[selectedGroup[0]+1] then prepareGroup() end
  if showUI == nil then
    showUI = ui_imgui.BoolPtr(false)
  end
end

local optimizedTraffic = 0

local function onUpdate()
  if not showUI[0] then
    return
   end
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize)
  --group selector
  im.Text("Traffic Group")
  im.PushItemWidth(200)
  if im.Combo2("##Selected Preset", selectedGroup, groupString) then
    onGroupDataLoad()
    prepareGroup()
  end
  im.PopItemWidth()

  --basic vehicle settings
  im.Text("Number Of Cars")
  im.PushItemWidth(200)
  varAmount[0] = vehicleAmount
  if im.SliderFloat("##agentTrafficTool", varAmount, 1, 64, "%.0f") then
    vehicleAmount = varAmount[0]
  end
  im.PopItemWidth()

  if im.Checkbox("Use Pooling", usePoolingEnabled) then
    usePooling = usePoolingEnabled[0]
  end
  if im.IsItemHovered() then
    im.BeginTooltip()
    im.Text("Enables vehicle pooling")
    im.EndTooltip()
  end

  if usePooling == true then
    im.Text("Number Of Pooled Cars")
    im.PushItemWidth(200)
    varPooling[0] = usePoolingNumber
    if im.SliderFloat("##agentTrafficPooled", varPooling, 1, 64, "%.0f") then
      usePoolingNumber = varPooling[0]
    end
    im.PopItemWidth()
  end
  if levelSpots > 0 then
    if im.Checkbox("Parked Vehicles", includeParkedEnabled) then
      includeParked = includeParkedEnabled[0]
    end
    if im.IsItemHovered() then
      im.BeginTooltip()
      im.Text("Includes parked vehicles in regular spawns, like how the official traffic spawning works")
      im.EndTooltip()
    end

    if includeParked == true then
      if includeParkedNumber > levelSpots then
        im.TextColored(im.ImVec4(1, 1, 0, 1), "Amount of parked is higher\nthan amount of parking spots!")
      end
      im.Text("Number Of Parked Cars")
      im.PushItemWidth(200)
      varParked[0] = includeParkedNumber
      if im.SliderFloat("##agentTrafficParked", varParked, 1, maxParked, "%.0f") then
        includeParkedNumber = varParked[0]
      end
      im.PopItemWidth()
    end
  else
    im.TextColored(im.ImVec4(1, 0, 0, 1), "This level does not support\nparked vehicles!")
    includeParked = false
  end

  --quick start option
  if im.Checkbox("Quick Start", quickStartEnabled) then
    quickStart = quickStartEnabled[0]
  end
  if im.IsItemHovered() then
    im.BeginTooltip()
    im.Text("Automatically start traffic after spawning")
    im.EndTooltip()
  end

  if im.Checkbox("Generate Plates On Spawn", platesOnSpawnEnabled) then
    platesOnSpawn = platesOnSpawnEnabled[0]
  end
  if im.IsItemHovered() then
    im.BeginTooltip()
    im.Text("Enables plate generation during spawning. Normal game behavior but may cause crashes on weak cpus (otherwise they are generated on traffic start)")
    im.EndTooltip()
  end

  --plate settings
  if im.TreeNode1("License Plate Settings") then

  im.Text("Plate Design")
  im.PushItemWidth(160)
  if im.Combo2("##Plate Design", selectedPlateDesign, plateDesignString) then
    --dump(licensePlates[selectedPlateDesign[0]])
  end
  im.PopItemWidth()

  im.Text("Alt Plate Models/Types")
  im.PushItemWidth(160)
  if plateShapeSupported == false then
    im.TextColored(im.ImVec4(1, 0, 0, 1), 'The current group does not support\nmodded plate models and therefore\nthis option will be ignored')
  else
    if im.Combo2("##Plate Shape", selectedPlateShape, plateShapeString) then
    end
    if im.IsItemHovered() then
      im.BeginTooltip()
      im.Text("Extra modded plate styles, only some plate designs supported!")
      im.EndTooltip()
    end
  end

  if selectedPlateShape[0] == 1 then
    if FS:directoryExists('vehicles/common/licenseplates/front_99') then
      im.TextColored(im.ImVec4(1, 1, 0, 1), 'This will force the "Italy 1999"\nplate design to be used, as it\nis required for this option\nto work')
      plateShapeInstalled = true
    else
      im.PushItemWidth(160)
      im.TextColored(im.ImVec4(1, 0, 0, 1), 'This requires "The Italian Mod"\nby gsbr_697 to function,\nwhich is not installed')
      plateShapeInstalled = false
      if im.Button("Download it here\n(Ingame repo)") then
        extensions.core_repository.uiShowMod('M51RLD32Y')
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text('https://www.beamng.com/resources/the-italian-mod.24405/')
        im.EndTooltip()
      end
    end
  end

  if selectedPlateShape[0] == 2 then
    if FS:directoryExists('vehicles/common/licenseplates/models/mercosur') then
      im.TextColored(im.ImVec4(1, 1, 0, 1), 'Only supported mod plate\ndesigns will work with this\nsetting! Double check before\nspawning traffic')
      plateShapeInstalled = true
    else
      im.TextColored(im.ImVec4(1, 0, 0, 1), 'This requires "Mercosur/Mercosul\nLicense Plate Pack" by RealVector\nto function, which is not installed')
      plateShapeInstalled = false
      if im.Button("Download it here\n(Ingame repo)") then
        extensions.core_repository.uiShowMod('MUAKPD25B')
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text('https://www.beamng.com/resources/mercosur-mercosul-license-plate-pack.29961/')
        im.EndTooltip()
      end
    end
  end

  if selectedPlateShape[0] == 3 then
    if FS:directoryExists('vehicles/common/UK_LicensePlates_JP') then
      im.TextColored(im.ImVec4(1, 1, 0, 1), 'Only supported mod plate\ndesigns will work with this\nsetting! Double check before\nspawning traffic')
      plateShapeInstalled = true
    else
      im.TextColored(im.ImVec4(1, 0, 0, 1), 'This requires "European License\nPlates Compilation" by JorgePinto\nto function, which is not installed')
      plateShapeInstalled = false
      if im.Button("Download it here\n(Ingame repo)") then
        extensions.core_repository.uiShowMod('MPH2FQWXK')
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text('https://www.beamng.com/resources/european-license-plates-compilation.6952/')
        im.EndTooltip()
      end
    end
  end

  if selectedPlateShape[0] == 4 then
    if FS:directoryExists('vehicles/common/licenseplates/models/f-52') then
      im.TextColored(im.ImVec4(1, 1, 0, 1), 'Only supported mod plate\ndesigns will work with this\nsetting! Double check before\nspawning traffic')
      plateShapeInstalled = true
    else
      im.TextColored(im.ImVec4(1, 0, 0, 1), 'This requires "Middle East License\nPlate Pack" by RealVector to\nfunction, which is not installed')
      plateShapeInstalled = false
      if im.Button("Download it here\n(Ingame repo)") then
        extensions.core_repository.uiShowMod('MOUXET72H')
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text('https://www.beamng.com/resources/middle-east-license-plate-pack-4-19.30105/')
        im.EndTooltip()
      end
    end
  end

  im.Text("Front Plate Usage")
  im.PushItemWidth(160)
  if im.Combo2("##Selected Plates", selectedPlates, platesString) then
  end
  if im.IsItemHovered() then
    im.BeginTooltip()
    im.Text("Only recommended for US maps/vehicle groups")
    im.EndTooltip()
  end
  im.PopItemWidth()
  im.TreePop()
  end

  im.Separator()

  --spawn traffics
  if currentGroup ~= nil then

    if alreadySpawnedWarning == true then
      im.TextColored(im.ImVec4(1, 0, 0, 1), 'Traffic is already spawned!\nAre you sure you want to spawn more?')
    end

    im.PushItemWidth(200)
    if im.Button("Spawn Traffic") then

      if alreadySpawned == true and alreadySpawnedWarning == false then
        alreadySpawnedWarning = true
      else
        alreadySpawnedWarning = false
        alreadySpawned = true
        if platesOnSpawn == false then
          if plateSkip == false then
            settings.setValue('SkipGenerateLicencePlate',true)
          end
        end
        guihooks.trigger('app:waiting', true)
        onGroupDataLoad()
        prepareGroup()
        preparePartsPlates(currentGroup)
        local targetAmount = vehicleAmount
        if usePooling == true then
          targetAmount = vehicleAmount + usePoolingNumber
        end
        extensions.core_multiSpawn.spawnGroup(currentGroup.data, targetAmount, {name = 'agentTrafficCurrent', shuffle = true, gap = 20, instant = true, configPopPower = 10})
        if includeParked == true then
          spawnParked()
        end
        if plateSkip == false then
          settings.setValue('SkipGenerateLicencePlate',false)
        end
        agentTrafficActive = true
        if quickStart == true then
          startTraffic()
        end
        guihooks.trigger('app:waiting', false)
      end
    end

    if im.IsItemHovered() then
      im.BeginTooltip()
      im.Text("Spawns traffic vehicles")
      im.EndTooltip()
    end

    if levelSpots > 0 then
      im.SameLine()

      if im.Button("Spawn Parked") then
        if plateSkip == false then
          settings.setValue('SkipGenerateLicencePlate',true)
        end
        guihooks.trigger('app:waiting', true)
        spawnParked()
        if plateSkip == false then
          settings.setValue('SkipGenerateLicencePlate',false)
        end
        guihooks.trigger('app:waiting', false)
      end

      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Spawns only parked vehicles, uses parked vehicle amount if available")
        im.EndTooltip()
      end
    end

    im.Separator()

    --make traffic happen
    if im.Button("Start Traffic   ") then
      startTraffic()
    end

    im.SameLine()

    if im.Button("Stop Traffic    ") then
      agentTrafficActive = false
      extensions.gameplay_traffic.deactivate(true)
    end

    if im.Button("Delete Traffic") then
      extensions.core_multiSpawn.deleteVehicles(targetAmount)
      alreadySpawned = false
    end

    if im.IsItemHovered() then
      im.BeginTooltip()
      im.Text("Delete all other vehicles")
      im.EndTooltip()
    end

    im.SameLine()
    if reloadPlatesJob and reloadPlatesJob.running and reloadPlatesJob.count and reloadPlatesJob.progress then
      im.Text("Reloaded: "..tostring(reloadPlatesJob.progress).."/"..tostring(reloadPlatesJob.count))
    else
      if im.Button("Reload plates") then
        reloadPlatesJob = extensions.core_jobsystem.create(reloadPlates, 1)
      end
    end

    if im.IsItemHovered() then
      im.BeginTooltip()
      im.Text("Reload traffic plates")
      im.EndTooltip()
    end

    im.PopItemWidth()
  else
    im.Text("Current group is missing")
  end
  im.End()
end

local function onClientStartMission()
  getParkingSpots()
end

local function onWindowMenuItem()
  showUI[0] = true
end

local function openUI()
  showUI[0] = true
end

local function hideUI()
  showUI[0] = false
end

local function toggleUI()
  if showUI[0] then
    hideUI()
  else
    openUI()
  end
end

M.show = openUI
M.hide = hideUI
M.toggle = toggleUI
M.testGroup = testGroup
M.onClientStartMission = onClientStartMission
M.onExtensionLoaded = onExtensionLoaded
M.onUpdate = onUpdate
return M