

local function onInit()
	ticktime = 0
	electrics.values.rear_steering_left_input = 0
	electrics.values.rear_steering_right_input = 0
	electrics.values.rear_steering = 0
	electrics.values.togglerscentering = 0
	togglelinkedsteering = 0
	electrics.values.effect = 0

end

local function onReset()

	electrics.values.rear_steering_left_input = 0
	electrics.values.rear_steering_right_input = 0
	electrics.values.rear_steering = 0
	electrics.values.effect = 0
end

local function updateGFX(dt)

	--gets the graphics frame time and makes a 20 tps clock, only used when self centering is disabled
	ticktime = ticktime + dt
	if ticktime > 1/20 then
	  ticktime = 0
	end
	
	if electrics.values['rpm'] < 1500 then
	electrics.values['run'] = 0
	else
	electrics.values['run'] = 1
	end
	
	-- turns the rear steering when assigned key is pressed
	if electrics.values.rear_steering_right_input == 1 and electrics.values.rear_steering_left_input == 0 and electrics.values.rear_steering < 1 then
	  if electrics.values.togglerscentering == 0 then
		electrics.values.rear_steering = 1 elseif ticktime == 0 then
		electrics.values.rear_steering = electrics.values.rear_steering + 0.1
	  end
	end

	if electrics.values.rear_steering_left_input == 1 and electrics.values.rear_steering_right_input == 0 and electrics.values.rear_steering > -1 then
	  if electrics.values.togglerscentering == 0 then
		electrics.values.rear_steering = -1 elseif ticktime == 0 then
		electrics.values.rear_steering = electrics.values.rear_steering - 0.1
	  end
	end

	-- returns the rear steering to center when in independent mode with centering enabled
	if electrics.values.rear_steering ~= 0 then
	  if electrics.values.rear_steering_left_input == electrics.values.rear_steering_right_input and electrics.values.togglerscentering == 0 then
	    electrics.values.rear_steering = 0
	  end
	end
		
	-- disables rear auto centering when linked steering is enabled so it sync correctly in multiplayer
	if togglelinkedsteering == 1 and electrics.values.togglerscentering == 0 then
	  electrics.values.togglerscentering = 1
	end

	-- sets steering to rear steering when linked steering is toggled
	if togglelinkedsteering == 1 then
	  electrics.values.rear_steering = electrics.values.steering_input
	end

end

-- public interface

local M = {}
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX
return M