--[[
    Copyright (c) 2025 LetsDrive
    This file is part of AW T-Wagen.

    Do not modify or reuse without permission
    If you want to use this code for your mod contact https://www.beamng.com/members/letsdrive537.507066/ to ask for permission.
]]

local M = {}

--customizable variable
local animationTime = 3

--other variables, ignore
local windowProgressL = 0
local windowProgressR = 0

local function updateWindow(dt)
    if not electrics or not electrics.values then return end

    local controlL = electrics.values.glass_FL_control or -1
    local controlR = electrics.values.glass_FR_control or -1

    if controlL == 1 then
        windowProgressL = math.min(windowProgressL + dt / animationTime, 1)
    elseif controlL == 0 then
        windowProgressL = math.max(windowProgressL - dt / animationTime, 0)
    end

    if controlR == 1 then
        windowProgressR = math.min(windowProgressR + dt / animationTime, 1)
    elseif controlR == 0 then
        windowProgressR = math.max(windowProgressR - dt / animationTime, 0)
    end

    electrics.values["window_fl_pos"] = windowProgressL
    electrics.values["window_fr_pos"] = windowProgressR
end

local function onReset()
    if not electrics or not electrics.values then return end

    windowProgressL = 0
    windowProgressR = 0

    electrics.values["window_fl_pos"] = windowProgressL
    electrics.values["window_fr_pos"] = windowProgressR

    electrics.values.glass_FL_control = -1
    electrics.values.glass_FR_control = -1
end

local function onInit()
    if not electrics or not electrics.values then return end

    electrics.values["window_fl_pos"] = windowProgressL
    electrics.values["window_fr_pos"] = windowProgressR
end

local function updateGFX(dt)
    updateWindow(dt)
end

M.updateGFX = updateGFX
M.onReset = onReset
M.onInit = onInit

return M