-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
M.type = "auxiliary"
local map_FR = 0
local map_FL = 0
local map_RR = 0
local map_RL = 0
local beams = 0
local starting = 0
local dim = 0
local dimswitch = 0
local window_active = nil

local window_FR = 0
local window_FL = 0
local window_RR = 0
local window_RL = 0
local vent_R = 0
local vent_L = 0
local lightswitch = 0

local function dToggleDim()
    if dim == 1 or dim == 0 then
        dim = 2
        dimswitch = 1
    else
        dim = 1
        dimswitch = 0
    end
    if beams ~= 0 then
        beams = dim
        electrics.setLightsState(beams)
    end
end

local function dToggleLights()
    if beams == 0 then
        beams = dim > 0 and dim or 1
		lightswitch = 1
    else
        beams = 0
        lightswitch = 0
    end
    electrics.setLightsState(beams)
end

local function light_flash_highbeams(enabled)
  if enabled then
    lightsSavedState = lightsState
    lightsState = 2
  else
    lightsState = lightsSavedState
  end
end

local function dToggleMapFR()
    map_FR = 1 - map_FR
end

local function dToggleMapFL()
    map_FL = 1 - map_FL
end

local function dToggleMapRR()
    map_RR = 1 - map_RR
end

local function dToggleMapRL()
    map_RL = 1 - map_RL
end

local function dIgn()
    if starting == 1 or starting == 2 then
        starting = 0
    else
        starting = 1
    end
	electrics.setIgnitionState(starting)
end

local function dWindowUpFRStart() window_active = 'FRup' end
local function dWindowDownFRStart() window_active = 'FRdown' end
local function dWindowUpFRStop() window_active = nil end
local function dWindowDownFRStop() window_active = nil end

local function dWindowUpFLStart() window_active = 'FLup' end
local function dWindowDownFLStart() window_active = 'FLdown' end
local function dWindowUpFLStop() window_active = nil end
local function dWindowDownFLStop() window_active = nil end

local function dWindowUpRRStart() window_active = 'RRup' end
local function dWindowDownRRStart() window_active = 'RRdown' end
local function dWindowUpRRStop() window_active = nil end
local function dWindowDownRRStop() window_active = nil end

local function dWindowUpRLStart() window_active = 'RLup' end
local function dWindowDownRLStart() window_active = 'RLdown' end
local function dWindowUpRLStop() window_active = nil end
local function dWindowDownRLStop() window_active = nil end

local function dVentOpenLStart() window_active = 'Lopen' end
local function dVentCloseLStart() window_active = 'Lclose' end
local function dVentOpenLStop() window_active = nil end
local function dVentCloseLStop() window_active = nil end

local function dVentOpenRStart() window_active = 'Ropen' end
local function dVentCloseRStart() window_active = 'Rclose' end
local function dVentOpenRStop() window_active = nil end
local function dVentCloseRStop() window_active = nil end

local function updateGFX(dt)

    if window_active == 'FRup' and window_FR > 0 then
		window_FR = window_FR - 0.005
		if window_FR < 0 then
			window_FR = 0
		end
	end
    if window_active == 'FRdown' and window_FR < 1 then
		window_FR = window_FR + 0.005
		if window_FR > 1 then
			window_FR = 1
		end
	end

    if window_active == 'FLup' and window_FL > 0 then
		window_FL = window_FL - 0.005
		if window_FL < 0 then
			window_FL = 0
		end
	end
    if window_active == 'FLdown' and window_FL < 1 then
		window_FL = window_FL + 0.005
		if window_FL > 1 then
			window_FL = 1
		end
	end

    if window_active == 'RRup' and window_RR > 0 then
		window_RR = window_RR - 0.005
		if window_RR < 0 then
			window_RR = 0
		end
	end
    if window_active == 'RRdown' and window_RR < 1 then
		window_RR = window_RR + 0.005
		if window_RR > 1 then
			window_RR = 1
		end
	end

    if window_active == 'RLup' and window_RL > 0 then
		window_RL = window_RL - 0.005
		if window_RL < 0 then
			window_RL = 0
		end
	end
    if window_active == 'RLdown' and window_RL < 1 then
		window_RL = window_RL + 0.005
		if window_RL > 1 then
			window_RL = 1
		end
	end

    if window_active == 'Lopen' and vent_L > 0 then
		vent_L = vent_L - 0.005
		if vent_L < 0 then
			vent_L = 0
		end
	end
    if window_active == 'Lclose' and vent_L < 1 then
		vent_L = vent_L + 0.005
		if vent_L > 1 then
			vent_L = 1
		end
	end

    if window_active == 'Ropen' and vent_R > 0 then
		vent_R = vent_R - 0.005
		if vent_R < 0 then
			vent_R = 0
		end
	end
    if window_active == 'Rclose' and vent_R < 1 then
		vent_R = vent_R + 0.005
		if vent_R > 1 then
			vent_R = 1
		end
	end
	
    electrics.values.lightswitch = lightswitch
    electrics.values.dimswitch = dimswitch
    electrics.values.map_FR = map_FR
    electrics.values.map_FL = map_FL
    electrics.values.map_RR = map_RR
    electrics.values.map_RL = map_RL
    electrics.values.vent_R = vent_R
    electrics.values.vent_L = vent_L
    electrics.values.window_FR = window_FR
    electrics.values.window_FL = window_FL
    electrics.values.window_RR = window_RR
    electrics.values.window_RL = window_RL
    beams = electrics.values.lights_state
    dim = electrics.values.lights_state
end

local function onReset()
    window_FR = window_FR
    window_FL = window_FL
    window_RR = window_RR
    window_RL = window_RL
    vent_R = vent_R
    vent_L = vent_L
end

-- public interface
M.onReset = onReset
M.onInit = onInit

M.toggle_lights = toggle_lights
M.dToggleLights = dToggleLights
M.dToggleDim = dToggleDim
M.dToggleMapFR = dToggleMapFR
M.dToggleMapFL = dToggleMapFL
M.dToggleMapRR = dToggleMapRR
M.dToggleMapRL = dToggleMapRL

M.dIgn = dIgn

M.dWindowUpFRStart = dWindowUpFRStart
M.dWindowUpFRStop = dWindowUpFRStop
M.dWindowDownFRStart = dWindowDownFRStart
M.dWindowDownFRStop = dWindowDownFRStop
M.dWindowUpFLStart = dWindowUpFLStart
M.dWindowUpFLStop = dWindowUpFLStop
M.dWindowDownFLStart = dWindowDownFLStart
M.dWindowDownFLStop = dWindowDownFLStop
M.dWindowUpRRStart = dWindowUpRRStart
M.dWindowUpRRStop = dWindowUpRRStop
M.dWindowDownRRStart = dWindowDownRRStart
M.dWindowDownRRStop = dWindowDownRRStop
M.dWindowUpRLStart = dWindowUpRLStart
M.dWindowUpRLStop = dWindowUpRLStop
M.dWindowDownRLStart = dWindowDownRLStart
M.dWindowDownRLStop = dWindowDownRLStop
M.dVentOpenLStart = dVentOpenLStart
M.dVentOpenLStop = dVentOpenLStop
M.dVentCloseLStart = dVentCloseLStart
M.dVentCloseLStop = dVentCloseLStop
M.dVentOpenRStart = dVentOpenRStart
M.dVentOpenRStop = dVentOpenRStop
M.dVentCloseRStart = dVentCloseRStart
M.dVentCloseRStop = dVentCloseRStop

M.updateGFX = updateGFX

return M