-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
local roofActive = 0
local dTrunk = 0
local dRoof = 0
local dFlip = 0

local roofLocked = false
local roofStage = 0
local roofUnlatched = 0
local roofDirection = 1 -- 0 is up, 1 is down

local trunkOpenTime = 2
local trunkCloseTime = 2
local roofOpenTime = 11
local roofCloseTime = 13
local flipOpenTime = 3
local flipCloseTime = 3

local roofTimer = 0
local printer = 0

local function dToggleRoof()
	if roofLocked then return end
	if roofDirection == 1 then
		roofDirection = 0
	else
		roofDirection = 1
	end
	if roofActive == 0 then
		roofActive = 1
		roofStage = 1
		roofLocked = true
	end
end

local function dRoofUnlatch()
	if roofActive == 0 then
		if roofUnlatched == 1 then
			roofUnlatched = 0
		else
			roofUnlatched = 1
		end
	end
end

local function updateGFX(dt)
	
	if roofActive == 1 then
		roofTimer = roofTimer + dt
	else
		roofTimer = 0
	end
	
	-- open trunk only
	if roofActive == 1 and roofDirection == 0 and roofUnlatched == 0 then
		if roofStage == 1 then
			dTrunk = 1
			if roofTimer >= trunkOpenTime then
				roofTimer = 0
				roofStage = 2
			end
		end
	end

	-- close trunk only
	if roofActive == 1 and roofDirection == 1 and roofUnlatched == 0 then
		if roofStage == 2 then
			dTrunk = 0
			if roofTimer >= trunkCloseTime then
				roofTimer = 0
				roofStage = 0
				roofActive = 0
			end
		end
	end
	
	-- roof down
	if roofActive == 1 and roofDirection == 0 and roofUnlatched == 1 then
		if roofStage == 1 then
			dTrunk = 1
			if roofTimer >= trunkOpenTime then
				roofTimer = 0
				roofStage = 2
			end
		elseif roofStage == 2 then
			dFlip = 1
			if roofTimer >= flipOpenTime then
				roofTimer = 0
				roofStage = 3
			end
		elseif roofStage == 3 then
			dRoof = 1
			if roofTimer >= roofOpenTime then
				roofTimer = 0
				roofStage = 4
			end
		elseif roofStage == 4 then
			dTrunk = 0
			if roofTimer >= trunkCloseTime then
				roofTimer = 0
				roofStage = 0
				roofActive = 0
				roofLocked = false
			end
		end
	end
	
	-- roof up
	if roofActive == 1 and roofDirection == 1 and roofUnlatched == 1 then
		if roofStage == 1 then
			dTrunk = 1
			if roofTimer >= trunkOpenTime then
				roofTimer = 0
				roofStage = 2
			end
		elseif roofStage == 2 then
			dFlip = 0
			if roofTimer >= flipCloseTime then
				roofTimer = 0
				roofStage = 3
			end
		elseif roofStage == 3 then
			dRoof = 0
			if roofTimer >= roofCloseTime then
				roofTimer = 0
				roofStage = 4
			end
		elseif roofStage == 4 then
			dTrunk = 0
			if roofTimer >= trunkCloseTime then
				roofTimer = 0
				roofStage = 0
				roofActive = 0
				roofUnlatched = 0
				roofLocked = false
			end
		end
	end
	
    electrics.values.dTrunk = dTrunk
    electrics.values.dRoof = dRoof
    electrics.values.dFlip = dFlip
end

local function onReset()
	roofLocked = false
    dTrunk = 0
    dRoof = 0
    dFlip = 0
    roofStage = 0
    roofActive = 0
    roofUnlatched = 0
    roofDirection = 1
	roofTimer = 0
end

-- public interface
M.onReset = onReset
M.onInit = onInit

M.dTrunk = dTrunk
M.dRoof = dRoof
M.dFlip = dFlip
M.dToggleRoof = dToggleRoof
M.dRoofUnlatch = dRoofUnlatch

M.updateGFX = updateGFX

return M