-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['doorlight_R'] = 0
  electrics.values['doorlight_L'] = 0
  electrics.values['doorlight'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['doorlight'] = (electrics.values['doorlight_R'] + electrics.values['doorlight_L'])
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.doorlight_R = doorlight_R
M.doorlight_L = doorlight_L
M.doorlight = doorlight

return M
