-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local function onInit()
    electrics.values['compass'] = 0
end

local function reset()
    onInit()
end

local function updateGFX(dt)
	local roll, pitch, yaw = obj:getRollPitchYaw()
    electrics.values['compass'] = yaw*180/math.pi+180
end

-- public interface
M.onInit    = onInit
M.onReset   = reset
M.updateGFX = updateGFX

return M