-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local helper = require('scenario/scenariohelper')
local running = false
local playerWon = false

local function reset()
    running = false
    playerWon = false
end

local function fail(reason)
    reset()
    scenario_scenarios.finish({failed = reason})
end

local function success()
  local scenario = scenario_scenarios.getScenario()
  if not scenario then return end

  local finalTime = scenario.timer
  local minutes = math.floor(finalTime / 60);
  local seconds = finalTime - (minutes * 60);
  local timeStr = ''
  if minutes > 0 then
      timeStr = string.format("%02.0f:%05.2f", minutes, seconds)
  else
      timeStr = string.format("%0.2f", seconds) .. 's'
  end
  local result = {msg = "scenarios.jungle_rock_island.drag_race.win.msg", timeStr}
  scenario_scenarios.finish(result)
  reset()
end



local function onRaceInit()
    helper.setAiPath({vehicleName = 'aiCar', waypoints = {'wp_ai_target'}, aggression = 2})
    helper.queueLuaCommandByName("scenario_player0", "controller.mainController.setGearboxMode('realistic')")
end

local function onRaceStart()
    reset()

    --helper.queueLuaCommandByName('aiCar', 'dragAi.go()')
    helper.trackVehicle('scenario_player0', 'playerCar')
    helper.trackVehicle('aiCar', 'aiCar')

    running = true
end

local function onRaceTick(raceTick)
  local scenario = scenario_scenarios.getScenario()
  if not scenario then return end
  if running and scenario.timer >= 18 then
      fail("scenarios.jungle_rock_island.drag_race.fail.msg")
  end
end

local function onRaceWaypointReached(data)
  local playerVehicleId = be:getPlayerVehicleID(0)
  if data.vehicleId == playerVehicleId then
    local playerDistance = helper.getDistanceBetweenSceneObjects('scenario_player0', 'wp_target_distance')
    local aiDistance = helper.getDistanceBetweenSceneObjects('aiCar', 'wp_target_distance')
    playerWon = playerDistance <= aiDistance
  end
end

local function onRaceResult(time)
    if playerWon then
        success()
    else
        fail("scenarios.jungle_rock_island.drag_race.fail.msg")
    end
    --helper.queueLuaCommandByName('aiCar', 'dragAi.reset()')
end

local function onScenarioRestarted(scenario)
   -- helper.queueLuaCommandByName('aiCar', 'dragAi.reset()')
end

M.onRaceStart = onRaceStart
M.onRaceInit = onRaceInit
M.onRaceTick = onRaceTick
M.onRaceResult = onRaceResult
M.onRaceWaypointReached = onRaceWaypointReached
M.onScenarioRestarted = onScenarioRestarted

return M
