-- Originally made by StrictBark
-- https://www.beamng.com/threads/project-chimes-startup-and-warning-chimes.106646/

local M = {}
local volume, pitch = 1.5, 1
local camNode = 0
local timer = 0
local lastIgnitionLevel = 0
local chimeTimer = 0
local chimePlaying = false
local chimeDuration = 1
local nextChimeTime = 0
local chimeCompleted = false

local function inside()
    local cam = obj:getCameraPosition()
    local seat = obj:getPosition() + obj:getNodePosition(camNode)
    return cam and seat and cam:distance(seat) <= 0.6
end

local function update(dt)
    local ignitionLevel = electrics.values['ignitionLevel']
    local engineRunning = electrics.values.engineRunning
	local ignitionOn = (ignitionLevel > 0)
    if spawnedRecently and ignitionLevel < 2 then
        spawnedRecently = false
    end
    local ignitionChimeActive = (ignitionLevel == 2 and engineRunning and not spawnedRecently)
    local anyDoorOpen = (electrics.values['door_FL_coupler_notAttached'] == 1 or 
                         electrics.values['door_FR_coupler_notAttached'] == 1 or 
                         electrics.values['door_RL_coupler_notAttached'] == 1 or 
                         electrics.values['door_RR_coupler_notAttached'] == 1)
    local doorChimeActive = ignitionOn and anyDoorOpen
    if lastIgnitionLevel == 2 and ignitionLevel ~= 2 then
        chimePlaying = false
        chimeTimer = 0
        nextChimeTime = 0
        chimeCompleted = false
    end
	local isInside = inside()
    if isInside and not doorChimeActive then
        if ignitionChimeActive and not chimeCompleted then
            if not chimePlaying then
                chimePlaying = true
                chimeTimer = 0
            end
            chimeTimer = chimeTimer + dt
            if chimeTimer >= nextChimeTime and chimeTimer < 4 then
                obj:playSFXOnce("chimeOn.wav", camNode, volume, pitch)
                nextChimeTime = chimeTimer + chimeDuration
            end
            if chimeTimer >= 1 then
                chimePlaying = false
                chimeCompleted = true
                obj:playSFXOnce("chimeOff.wav", camNode, volume, pitch)
            end
        end
    else
        if not isInside then
            if chimePlaying then
                chimePlaying = false
                chimeTimer = 0
                nextChimeTime = 0
                chimeCompleted = true
            end
        end
    end
    lastIgnitionLevel = ignitionLevel
end

local function init()
    camNode = beamstate.nodeNameMap["driver"] or 0
    obj:createSFXSource("/art/sound/Camry_xNME/chimeOn.wav", "Audio2D", "chimeOn.wav", -1)
    obj:createSFXSource("/art/sound/Camry_xNME/chimeOff.wav", "Audio2D", "chimeOff.wav", -1)

        -- Reset chime state on vehicle reset/spawn
    chimePlaying = false
    chimeTimer = 0
    nextChimeTime = 0
    chimeCompleted = false
    lastIgnitionLevel = 0
    spawnedRecently = true
end

M.onInit = init
M.updateGFX = update
return M