-- Made by xNME
-- DO NOT USE WITHOUT PERMISSION

local M = {}
local SmoothedTable = {}

-- Initialize electric smoothing
local function initTable(electric, type, suffix)
  local newSmooth = {}
  newSmooth.electric = electric .. suffix
  newSmooth.baseElectric = electric
  newSmooth.type = type
  electrics.values[newSmooth.electric] = 0
  return newSmooth
end

local function addSmoothedLinear(name, speed)
  local newSmooth = initTable(name, "linear", "linear")
  newSmooth.speed = speed
  table.insert(SmoothedTable, newSmooth)
end

local function init()
  SmoothedTable = {}
  addSmoothedLinear("glassdoor_FL", 2.5)
  addSmoothedLinear("glassdoor_FR", 2.5)
  addSmoothedLinear("glassdoor_RL", 2.5)
  addSmoothedLinear("glassdoor_RR", 2.5)
end

-- Smooth interpolation
local function updateLinear(st, dt)
  if electrics.values[st.baseElectric] == nil then return end
  local targetValue = electrics.values[st.baseElectric]
  local targetSpeed = st.speed
  local currentValue = electrics.values[st.electric]

  if targetValue < currentValue then
    targetSpeed = -targetSpeed
  end

  currentValue = currentValue + (dt / targetSpeed)
  if currentValue < targetValue and targetSpeed < 0 then currentValue = targetValue end
  if currentValue > targetValue and targetSpeed > 0 then currentValue = targetValue end

  electrics.values[st.electric] = currentValue
end

-- Main update: reads up/down electric triggers
local function updateGFX(dt)
  for _, w in ipairs({ "glassdoor_FL", "glassdoor_FR", "glassdoor_RL", "glassdoor_RR" }) do
    local down = electrics.values[w .. "_down"] or 0
    local up   = electrics.values[w .. "_up"] or 0
    local val  = electrics.values[w] or 0

    -- Hold “down” → lowers window; hold “up” → raises window
    if down > 0.5 then
      val = math.max(val - dt * 0.5, 0)
    elseif up > 0.5 then
      val = math.min(val + dt * 0.5, 1)
    end

    electrics.values[w] = val
  end

  for _, st in ipairs(SmoothedTable) do
    if st.type == "linear" then
      updateLinear(st, dt)
    end
  end
end

M.updateGFX = updateGFX
M.onInit    = init
M.onReset   = init

return M
