-- Made by xNME
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local parts = {
    sunroofblanket   = { speed = 0.5, closed = 0.00, open = 0.45 },
    rearwindowblanket = { speed = 0.5, closed = 0.00, open = 1.00 }
}

local state = {}

local function moveTowards(v, t, step)
    if v < t then return math.min(v + step, t) else return math.max(v - step, t) end
end

local function initPart(name, p)
    state[name] = state[name] or { val = p.closed, target = p.closed, lastTrig = 0 }
    if electrics then electrics.values[name] = state[name].val end
end

local function onInit()
    for name, p in pairs(parts) do initPart(name, p) end
end

local function handlePart(name, p, dt)
    local s = state[name]
    local trig = (electrics.values[name .. "_trigger"] or 0)

    if trig > 0.5 and s.lastTrig <= 0.5 then
        s.target = (s.target == p.open) and p.closed or p.open
    end
    s.lastTrig = trig

    local step = p.speed * dt
    s.val = moveTowards(s.val, s.target, step)

    electrics.values[name] = s.val
end

local function updateGFX(dt)
    if not electrics then return end
    for name, p in pairs(parts) do
        handlePart(name, p, dt)
    end
end

local function resetPart(name, p)
    local s = state[name]
    s.val = p.closed
    s.target = p.closed
    s.lastTrig = 0
    if electrics then
        electrics.values[name] = s.val
        electrics.values[name .. "_trigger"] = 0
    end
end

local function onReset()
    for name, p in pairs(parts) do resetPart(name, p) end
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        onReset()
    end
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX
M.onVehicleActiveChanged = onVehicleActiveChanged

return M
