-- Made by xNME
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local controls = {
    { triggerKey = "seatfoldL_trigger", outputKey = "seatfoldL", value = 0, dir = 1 },
    { triggerKey = "seatfoldR_trigger", outputKey = "seatfoldR", value = 0, dir = 1 },
}

local speed = 0.5
local minLimit, maxLimit = 0, 1
local defaultValue = 0

local function onInit()
    for _, control in ipairs(controls) do
        control.value = defaultValue
        control.dir = 1
        electrics.values[control.outputKey] = control.value
    end
end

local function onReset()
    for _, control in ipairs(controls) do
        control.value = defaultValue
        control.dir = 1
        electrics.values[control.outputKey] = control.value
    end
end

local function updateGFX(dt)
    if not electrics then return end

    for _, control in ipairs(controls) do
        local triggerValue = electrics.values[control.triggerKey] or 0

        if triggerValue > 0.5 then

            control.value = control.value + control.dir * speed * dt

            if control.value >= maxLimit then
                control.value = maxLimit
                control.dir = -1
            elseif control.value <= minLimit then
                control.value = minLimit
                control.dir = 1
            end
        end

        electrics.values[control.outputKey] = control.value
    end
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M
